/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class RecursiveDescentParser
extends Parser {
    public RecursiveDescentParser(Reader reader) throws ParserCreationException {
        super(reader);
    }

    public RecursiveDescentParser(Reader reader, Analyzer analyzer) throws ParserCreationException {
        super(reader, analyzer);
    }

    public RecursiveDescentParser(Tokenizer tokenizer) {
        super(tokenizer);
    }

    public RecursiveDescentParser(Tokenizer tokenizer, Analyzer analyzer) {
        super(tokenizer, analyzer);
    }

    public void addPattern(ProductionPattern productionPattern) throws ParserCreationException {
        if (productionPattern.isMatchingEmpty()) {
            throw new ParserCreationException(3, productionPattern.getName(), "zero elements can be matched (minimum is one)");
        }
        if (productionPattern.isLeftRecursive()) {
            throw new ParserCreationException(3, productionPattern.getName(), "left recursive patterns are not allowed");
        }
        super.addPattern(productionPattern);
    }

    public void prepare() throws ParserCreationException {
        super.prepare();
        this.setInitialized(false);
        Iterator iterator = this.getPatterns().iterator();
        while (iterator.hasNext()) {
            this.calculateLookAhead((ProductionPattern)iterator.next());
        }
        this.setInitialized(true);
    }

    protected Node parseStart() throws ParseException {
        Node node = this.parsePattern(this.getStartPattern());
        Token token = this.peekToken(0);
        if (token != null) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("<EOF>");
            throw new ParseException(4, token.toShortString(), arrayList, token.getStartLine(), token.getStartColumn());
        }
        return node;
    }

    private Node parsePattern(ProductionPattern productionPattern) throws ParseException {
        ProductionPatternAlternative productionPatternAlternative = productionPattern.getDefaultAlternative();
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            ProductionPatternAlternative productionPatternAlternative2 = productionPattern.getAlternative(i);
            if (productionPatternAlternative == productionPatternAlternative2 || !this.isNext(productionPatternAlternative2)) continue;
            return this.parseAlternative(productionPatternAlternative2);
        }
        if (productionPatternAlternative == null || !this.isNext(productionPatternAlternative)) {
            this.throwParseException(this.findUnion(productionPattern));
        }
        return this.parseAlternative(productionPatternAlternative);
    }

    private Node parseAlternative(ProductionPatternAlternative productionPatternAlternative) throws ParseException {
        Production production = this.newProduction(productionPatternAlternative.getPattern());
        this.enterNode(production);
        for (int i = 0; i < productionPatternAlternative.getElementCount(); ++i) {
            try {
                this.parseElement(production, productionPatternAlternative.getElement(i));
                continue;
            }
            catch (ParseException parseException) {
                this.addError(parseException, true);
                this.nextToken();
                --i;
            }
        }
        return this.exitNode(production);
    }

    private void parseElement(Production production, ProductionPatternElement productionPatternElement) throws ParseException {
        for (int i = 0; i < productionPatternElement.getMaxCount() && (i < productionPatternElement.getMinCount() || this.isNext(productionPatternElement)); ++i) {
            Node node;
            if (productionPatternElement.isToken()) {
                node = this.nextToken(productionPatternElement.getId());
                this.enterNode(node);
                this.addNode(production, this.exitNode(node));
                continue;
            }
            node = this.parsePattern(this.getPattern(productionPatternElement.getId()));
            this.addNode(production, node);
        }
    }

    private boolean isNext(ProductionPattern productionPattern) {
        LookAheadSet lookAheadSet = productionPattern.getLookAhead();
        if (lookAheadSet == null) {
            return false;
        }
        return lookAheadSet.isNext(this);
    }

    private boolean isNext(ProductionPatternAlternative productionPatternAlternative) {
        LookAheadSet lookAheadSet = productionPatternAlternative.getLookAhead();
        if (lookAheadSet == null) {
            return false;
        }
        return lookAheadSet.isNext(this);
    }

    private boolean isNext(ProductionPatternElement productionPatternElement) {
        LookAheadSet lookAheadSet = productionPatternElement.getLookAhead();
        if (lookAheadSet != null) {
            return lookAheadSet.isNext(this);
        }
        if (productionPatternElement.isToken()) {
            return productionPatternElement.isMatch(this.peekToken(0));
        }
        return this.isNext(this.getPattern(productionPatternElement.getId()));
    }

    private void calculateLookAhead(ProductionPattern productionPattern) throws ParserCreationException {
        ProductionPatternAlternative productionPatternAlternative;
        int n;
        LookAheadSet lookAheadSet = new LookAheadSet(0);
        int n2 = 1;
        CallStack callStack = new CallStack();
        callStack.push(productionPattern.getName(), 1);
        LookAheadSet lookAheadSet2 = new LookAheadSet(1);
        LookAheadSet[] lookAheadSetArray = new LookAheadSet[productionPattern.getAlternativeCount()];
        for (n = 0; n < productionPattern.getAlternativeCount(); ++n) {
            productionPatternAlternative = productionPattern.getAlternative(n);
            lookAheadSetArray[n] = this.findLookAhead(productionPatternAlternative, 1, 0, callStack, null);
            productionPatternAlternative.setLookAhead(lookAheadSetArray[n]);
            lookAheadSet2.addAll(lookAheadSetArray[n]);
        }
        if (productionPattern.getLookAhead() == null) {
            productionPattern.setLookAhead(lookAheadSet2);
        }
        LookAheadSet lookAheadSet3 = this.findConflicts(productionPattern, 1);
        while (!lookAheadSet3.isEmpty()) {
            callStack.clear();
            callStack.push(productionPattern.getName(), ++n2);
            lookAheadSet3.addAll(lookAheadSet);
            for (n = 0; n < productionPattern.getAlternativeCount(); ++n) {
                productionPatternAlternative = productionPattern.getAlternative(n);
                if (lookAheadSetArray[n].hasIntersection(lookAheadSet3)) {
                    lookAheadSetArray[n] = this.findLookAhead(productionPatternAlternative, n2, 0, callStack, lookAheadSet3);
                    productionPatternAlternative.setLookAhead(lookAheadSetArray[n]);
                }
                if (!lookAheadSetArray[n].hasIntersection(lookAheadSet3)) continue;
                if (productionPattern.getDefaultAlternative() == null) {
                    productionPattern.setDefaultAlternative(n);
                    continue;
                }
                if (productionPattern.getDefaultAlternative() == productionPatternAlternative) continue;
                lookAheadSet2 = lookAheadSetArray[n].createIntersection(lookAheadSet3);
                this.throwAmbiguityException(productionPattern.getName(), null, lookAheadSet2);
            }
            lookAheadSet = lookAheadSet3;
            lookAheadSet3 = this.findConflicts(productionPattern, n2);
        }
        for (n = 0; n < productionPattern.getAlternativeCount(); ++n) {
            this.calculateLookAhead(productionPattern.getAlternative(n), 0);
        }
    }

    private void calculateLookAhead(ProductionPatternAlternative productionPatternAlternative, int n) throws ParserCreationException {
        LookAheadSet lookAheadSet = new LookAheadSet(0);
        int n2 = 1;
        if (n >= productionPatternAlternative.getElementCount()) {
            return;
        }
        ProductionPattern productionPattern = productionPatternAlternative.getPattern();
        ProductionPatternElement productionPatternElement = productionPatternAlternative.getElement(n);
        if (productionPatternElement.getMinCount() == productionPatternElement.getMaxCount()) {
            this.calculateLookAhead(productionPatternAlternative, n + 1);
            return;
        }
        LookAheadSet lookAheadSet2 = this.findLookAhead(productionPatternElement, 1, new CallStack(), null);
        LookAheadSet lookAheadSet3 = this.findLookAhead(productionPatternAlternative, 1, n + 1, new CallStack(), null);
        String string = "at position " + (n + 1);
        LookAheadSet lookAheadSet4 = this.findConflicts(productionPattern.getName(), string, lookAheadSet2, lookAheadSet3);
        while (!lookAheadSet4.isEmpty()) {
            lookAheadSet4.addAll(lookAheadSet);
            lookAheadSet2 = this.findLookAhead(productionPatternElement, ++n2, new CallStack(), lookAheadSet4);
            lookAheadSet3 = this.findLookAhead(productionPatternAlternative, n2, n + 1, new CallStack(), lookAheadSet4);
            lookAheadSet2 = lookAheadSet2.createCombination(lookAheadSet3);
            productionPatternElement.setLookAhead(lookAheadSet2);
            if (lookAheadSet2.hasIntersection(lookAheadSet4)) {
                lookAheadSet2 = lookAheadSet2.createIntersection(lookAheadSet4);
                this.throwAmbiguityException(productionPattern.getName(), string, lookAheadSet2);
            }
            lookAheadSet = lookAheadSet4;
            lookAheadSet4 = this.findConflicts(productionPattern.getName(), string, lookAheadSet2, lookAheadSet3);
        }
        this.calculateLookAhead(productionPatternAlternative, n + 1);
    }

    private LookAheadSet findLookAhead(ProductionPattern productionPattern, int n, CallStack callStack, LookAheadSet lookAheadSet) throws ParserCreationException {
        if (callStack.contains(productionPattern.getName(), n)) {
            throw new ParserCreationException(4, productionPattern.getName(), null);
        }
        callStack.push(productionPattern.getName(), n);
        LookAheadSet lookAheadSet2 = new LookAheadSet(n);
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            LookAheadSet lookAheadSet3 = this.findLookAhead(productionPattern.getAlternative(i), n, 0, callStack, lookAheadSet);
            lookAheadSet2.addAll(lookAheadSet3);
        }
        callStack.pop();
        return lookAheadSet2;
    }

    private LookAheadSet findLookAhead(ProductionPatternAlternative productionPatternAlternative, int n, int n2, CallStack callStack, LookAheadSet lookAheadSet) throws ParserCreationException {
        if (n <= 0 || n2 >= productionPatternAlternative.getElementCount()) {
            return new LookAheadSet(0);
        }
        LookAheadSet lookAheadSet2 = this.findLookAhead(productionPatternAlternative.getElement(n2), n, callStack, lookAheadSet);
        if (productionPatternAlternative.getElement(n2).getMinCount() == 0) {
            lookAheadSet2.addEmpty();
        }
        if (lookAheadSet == null) {
            if ((n -= lookAheadSet2.getMinLength()) > 0) {
                LookAheadSet lookAheadSet3 = this.findLookAhead(productionPatternAlternative, n, n2 + 1, callStack, null);
                lookAheadSet2 = lookAheadSet2.createCombination(lookAheadSet3);
            }
        } else if (lookAheadSet.hasOverlap(lookAheadSet2)) {
            LookAheadSet lookAheadSet4 = lookAheadSet2.createOverlaps(lookAheadSet);
            lookAheadSet = lookAheadSet.createFilter(lookAheadSet4);
            LookAheadSet lookAheadSet5 = this.findLookAhead(productionPatternAlternative, n -= lookAheadSet4.getMinLength(), n2 + 1, callStack, lookAheadSet);
            lookAheadSet2.removeAll(lookAheadSet4);
            lookAheadSet2.addAll(lookAheadSet4.createCombination(lookAheadSet5));
        }
        return lookAheadSet2;
    }

    private LookAheadSet findLookAhead(ProductionPatternElement productionPatternElement, int n, CallStack callStack, LookAheadSet lookAheadSet) throws ParserCreationException {
        LookAheadSet lookAheadSet2 = this.findLookAhead(productionPatternElement, n, 0, callStack, lookAheadSet);
        LookAheadSet lookAheadSet3 = new LookAheadSet(n);
        lookAheadSet3.addAll(lookAheadSet2);
        if (lookAheadSet == null || !lookAheadSet.hasOverlap(lookAheadSet3)) {
            return lookAheadSet3;
        }
        if (productionPatternElement.getMaxCount() == Integer.MAX_VALUE) {
            lookAheadSet2 = lookAheadSet2.createRepetitive();
        }
        int n2 = Math.min(n, productionPatternElement.getMaxCount());
        for (int i = 1; i < n2 && !(lookAheadSet2 = lookAheadSet2.createOverlaps(lookAheadSet)).isEmpty() && lookAheadSet2.getMinLength() < n; ++i) {
            LookAheadSet lookAheadSet4 = this.findLookAhead(productionPatternElement, n, 0, callStack, lookAheadSet.createFilter(lookAheadSet2));
            lookAheadSet2 = lookAheadSet2.createCombination(lookAheadSet4);
            lookAheadSet3.addAll(lookAheadSet2);
        }
        return lookAheadSet3;
    }

    private LookAheadSet findLookAhead(ProductionPatternElement productionPatternElement, int n, int n2, CallStack callStack, LookAheadSet lookAheadSet) throws ParserCreationException {
        LookAheadSet lookAheadSet2;
        if (productionPatternElement.isToken()) {
            lookAheadSet2 = new LookAheadSet(n);
            lookAheadSet2.add(productionPatternElement.getId());
        } else {
            ProductionPattern productionPattern = this.getPattern(productionPatternElement.getId());
            lookAheadSet2 = this.findLookAhead(productionPattern, n, callStack, lookAheadSet);
            if (callStack.contains(productionPattern.getName())) {
                lookAheadSet2 = lookAheadSet2.createRepetitive();
            }
        }
        return lookAheadSet2;
    }

    private LookAheadSet findConflicts(ProductionPattern productionPattern, int n) throws ParserCreationException {
        LookAheadSet lookAheadSet = new LookAheadSet(n);
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            LookAheadSet lookAheadSet2 = productionPattern.getAlternative(i).getLookAhead();
            for (int j = 0; j < i; ++j) {
                LookAheadSet lookAheadSet3 = productionPattern.getAlternative(j).getLookAhead();
                lookAheadSet.addAll(lookAheadSet2.createIntersection(lookAheadSet3));
            }
        }
        if (lookAheadSet.isRepetitive()) {
            this.throwAmbiguityException(productionPattern.getName(), null, lookAheadSet);
        }
        return lookAheadSet;
    }

    private LookAheadSet findConflicts(String string, String string2, LookAheadSet lookAheadSet, LookAheadSet lookAheadSet2) throws ParserCreationException {
        LookAheadSet lookAheadSet3 = lookAheadSet.createIntersection(lookAheadSet2);
        if (lookAheadSet3.isRepetitive()) {
            this.throwAmbiguityException(string, string2, lookAheadSet3);
        }
        return lookAheadSet3;
    }

    private LookAheadSet findUnion(ProductionPattern productionPattern) {
        LookAheadSet lookAheadSet;
        int n;
        int n2 = 0;
        for (n = 0; n < productionPattern.getAlternativeCount(); ++n) {
            lookAheadSet = productionPattern.getAlternative(n).getLookAhead();
            if (lookAheadSet.getMaxLength() <= n2) continue;
            n2 = lookAheadSet.getMaxLength();
        }
        lookAheadSet = new LookAheadSet(n2);
        for (n = 0; n < productionPattern.getAlternativeCount(); ++n) {
            lookAheadSet.addAll(productionPattern.getAlternative(n).getLookAhead());
        }
        return lookAheadSet;
    }

    private void throwParseException(LookAheadSet lookAheadSet) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (lookAheadSet.isNext(this, 1)) {
            lookAheadSet = lookAheadSet.createNextSet(this.nextToken().getId());
        }
        int[] nArray = lookAheadSet.getInitialTokens();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getTokenDescription(nArray[i]));
        }
        Token token = this.nextToken();
        throw new ParseException(4, token.toShortString(), arrayList, token.getStartLine(), token.getStartColumn());
    }

    private void throwAmbiguityException(String string, String string2, LookAheadSet lookAheadSet) throws ParserCreationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = lookAheadSet.getInitialTokens();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getTokenDescription(nArray[i]));
        }
        throw new ParserCreationException(5, string, string2, arrayList);
    }

    class CallStack {
        private ArrayList nameStack = new ArrayList();
        private ArrayList valueStack = new ArrayList();

        CallStack() {
        }

        public boolean contains(String string) {
            return this.nameStack.contains(string);
        }

        public boolean contains(String string, int n) {
            Integer n2 = new Integer(n);
            for (int i = 0; i < this.nameStack.size(); ++i) {
                if (!this.nameStack.get(i).equals(string) || !this.valueStack.get(i).equals(n2)) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.nameStack.clear();
            this.valueStack.clear();
        }

        public void push(String string, int n) {
            this.nameStack.add(string);
            this.valueStack.add(new Integer(n));
        }

        public void pop() {
            if (this.nameStack.size() > 0) {
                this.nameStack.remove(this.nameStack.size() - 1);
                this.valueStack.remove(this.valueStack.size() - 1);
            }
        }
    }
}

