/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;

public class ReaderBuffer
implements CharSequence {
    public static final int BLOCK_SIZE = 1024;
    private char[] buffer = new char[4096];
    private int pos = 0;
    private int length = 0;
    private Reader input = null;
    private int line = 1;
    private int column = 1;

    public ReaderBuffer(Reader reader) {
        this.input = reader;
    }

    public void dispose() {
        this.buffer = null;
        this.pos = 0;
        this.length = 0;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
    }

    public int position() {
        return this.pos;
    }

    public int lineNumber() {
        return this.line;
    }

    public int columnNumber() {
        return this.column;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int n) throws IndexOutOfBoundsException {
        return this.buffer[n];
    }

    public CharSequence subSequence(int n, int n2) throws IndexOutOfBoundsException {
        return new String(this.buffer, n, n2 - n);
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public int peek(int n) throws IOException {
        int n2 = this.pos + n;
        if (n2 >= this.length) {
            this.ensureBuffered(n + 1);
            n2 = this.pos + n;
        }
        return n2 >= this.length ? -1 : this.buffer[n2];
    }

    public String read(int n) throws IOException {
        this.ensureBuffered(n + 1);
        if (this.pos >= this.length) {
            return null;
        }
        int n2 = this.length - this.pos;
        if (n2 > n) {
            n2 = n;
        }
        this.updateLineColumnNumbers(n2);
        String string = new String(this.buffer, this.pos, n2);
        this.pos += n2;
        if (this.input == null && this.pos >= this.length) {
            this.dispose();
        }
        return string;
    }

    private void updateLineColumnNumbers(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.buffer[this.pos + i] == '\n') {
                ++this.line;
                this.column = 1;
                continue;
            }
            ++this.column;
        }
    }

    private void ensureBuffered(int n) throws IOException {
        int n2;
        if (this.input == null || this.pos + n < this.length) {
            return;
        }
        if (this.pos > 1024) {
            this.length -= this.pos - 16;
            System.arraycopy(this.buffer, this.pos - 16, this.buffer, 0, this.length);
            this.pos = 16;
        }
        if ((n2 = this.pos + n - this.length + 1) % 1024 != 0) {
            n2 = (1 + n2 / 1024) * 1024;
        }
        this.ensureCapacity(this.length + n2);
        try {
            while (this.input != null && n2 > 0) {
                int n3 = this.input.read(this.buffer, this.length, n2);
                if (n3 > 0) {
                    this.length += n3;
                    n2 -= n3;
                    continue;
                }
                this.input.close();
                this.input = null;
            }
        }
        catch (IOException iOException) {
            this.input = null;
            throw iOException;
        }
    }

    private void ensureCapacity(int n) {
        if (this.buffer.length >= n) {
            return;
        }
        if (n % 1024 != 0) {
            n = (1 + n / 1024) * 1024;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.buffer, 0, cArray, 0, this.length);
        this.buffer = cArray;
    }
}

