/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;

public class ProductionPattern {
    private int id;
    private String name;
    private boolean synthetic;
    private ArrayList alternatives;
    private int defaultAlt;
    private LookAheadSet lookAhead;

    public ProductionPattern(int n, String string) {
        this.id = n;
        this.name = string;
        this.synthetic = false;
        this.alternatives = new ArrayList();
        this.defaultAlt = -1;
        this.lookAhead = null;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isSyntetic() {
        return this.isSynthetic();
    }

    public boolean isLeftRecursive() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!productionPatternAlternative.isLeftRecursive()) continue;
            return true;
        }
        return false;
    }

    public boolean isRightRecursive() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!productionPatternAlternative.isRightRecursive()) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!productionPatternAlternative.isMatchingEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setSynthetic(boolean bl) {
        this.synthetic = bl;
    }

    public void setSyntetic(boolean bl) {
        this.setSynthetic(bl);
    }

    public int getAlternativeCount() {
        return this.alternatives.size();
    }

    public ProductionPatternAlternative getAlternative(int n) {
        return (ProductionPatternAlternative)this.alternatives.get(n);
    }

    public void addAlternative(ProductionPatternAlternative productionPatternAlternative) throws ParserCreationException {
        if (this.alternatives.contains(productionPatternAlternative)) {
            throw new ParserCreationException(3, this.name, "two identical alternatives exist");
        }
        productionPatternAlternative.setPattern(this);
        this.alternatives.add(productionPatternAlternative);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.id);
        stringBuffer.append(") ");
        for (n = 0; n < stringBuffer.length(); ++n) {
            stringBuffer2.append(" ");
        }
        for (n = 0; n < this.alternatives.size(); ++n) {
            if (n == 0) {
                stringBuffer.append("= ");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("| ");
            }
            stringBuffer.append(this.alternatives.get(n));
        }
        return stringBuffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAheadSet) {
        this.lookAhead = lookAheadSet;
    }

    ProductionPatternAlternative getDefaultAlternative() {
        if (this.defaultAlt >= 0) {
            Object e = this.alternatives.get(this.defaultAlt);
            return (ProductionPatternAlternative)e;
        }
        return null;
    }

    void setDefaultAlternative(int n) {
        if (n >= 0 && n < this.alternatives.size()) {
            this.defaultAlt = n;
        }
    }
}

