/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ProductionPattern;

public class Production
extends Node {
    private ProductionPattern pattern;
    private ArrayList children;

    public Production(ProductionPattern productionPattern) {
        this.pattern = productionPattern;
        this.children = new ArrayList();
    }

    boolean isHidden() {
        return this.pattern.isSynthetic();
    }

    public ProductionPattern getPattern() {
        return this.pattern;
    }

    public int getId() {
        return this.pattern.getId();
    }

    public String getName() {
        return this.pattern.getName();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChildAt(int n) {
        if (n < 0 || n >= this.children.size()) {
            return null;
        }
        return (Node)this.children.get(n);
    }

    public void addChild(Node node) {
        if (node != null) {
            node.setParent(this);
            this.children.add(node);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pattern.getName());
        stringBuffer.append('(');
        stringBuffer.append(this.pattern.getId());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

