/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;

public class ParserCreationException
extends Exception {
    public static final int INTERNAL_ERROR = 0;
    public static final int INVALID_PARSER_ERROR = 1;
    public static final int INVALID_TOKEN_ERROR = 2;
    public static final int INVALID_PRODUCTION_ERROR = 3;
    public static final int INFINITE_LOOP_ERROR = 4;
    public static final int INHERENT_AMBIGUITY_ERROR = 5;
    private int type;
    private String name;
    private String info;
    private ArrayList details;

    public ParserCreationException(int n, String string) {
        this(n, null, string);
    }

    public ParserCreationException(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public ParserCreationException(int n, String string, String string2, ArrayList arrayList) {
        this.type = n;
        this.name = string;
        this.info = string2;
        this.details = arrayList;
    }

    public int getErrorType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.details == null) {
            return null;
        }
        for (int i = 0; i < this.details.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
                if (i + 1 == this.details.size()) {
                    stringBuffer.append("and ");
                }
            }
            stringBuffer.append(this.details.get(i));
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                stringBuffer.append("parser is invalid, as ");
                stringBuffer.append(this.info);
                break;
            }
            case 2: {
                stringBuffer.append("token '");
                stringBuffer.append(this.name);
                stringBuffer.append("' is invalid, as ");
                stringBuffer.append(this.info);
                break;
            }
            case 3: {
                stringBuffer.append("production '");
                stringBuffer.append(this.name);
                stringBuffer.append("' is invalid, as ");
                stringBuffer.append(this.info);
                break;
            }
            case 4: {
                stringBuffer.append("infinite loop found in production pattern '");
                stringBuffer.append(this.name);
                stringBuffer.append("'");
                break;
            }
            case 5: {
                stringBuffer.append("inherent ambiguity in production '");
                stringBuffer.append(this.name);
                stringBuffer.append("'");
                if (this.info != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.info);
                }
                if (this.details == null) break;
                stringBuffer.append(" starting with ");
                if (this.details.size() > 1) {
                    stringBuffer.append("tokens ");
                } else {
                    stringBuffer.append("token ");
                }
                stringBuffer.append(this.getDetails());
                break;
            }
            default: {
                stringBuffer.append("internal error");
            }
        }
        return stringBuffer.toString();
    }
}

