/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;

public class ParseException
extends Exception {
    public static final int INTERNAL_ERROR = 0;
    public static final int IO_ERROR = 1;
    public static final int UNEXPECTED_EOF_ERROR = 2;
    public static final int UNEXPECTED_CHAR_ERROR = 3;
    public static final int UNEXPECTED_TOKEN_ERROR = 4;
    public static final int INVALID_TOKEN_ERROR = 5;
    public static final int ANALYSIS_ERROR = 6;
    private int type;
    private String info;
    private ArrayList details;
    private int line;
    private int column;

    public ParseException(int n, String string, int n2, int n3) {
        this(n, string, null, n2, n3);
    }

    public ParseException(int n, String string, ArrayList arrayList, int n2, int n3) {
        this.type = n;
        this.info = string;
        this.details = arrayList;
        this.line = n2;
        this.column = n3;
    }

    public int getErrorType() {
        return this.type;
    }

    public String getInfo() {
        return this.info;
    }

    public ArrayList getDetails() {
        return new ArrayList(this.details);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getErrorMessage());
        if (this.line > 0 && this.column > 0) {
            stringBuffer.append(", on line ");
            stringBuffer.append(this.line);
            stringBuffer.append(" column: ");
            stringBuffer.append(this.column);
        }
        return stringBuffer.toString();
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                stringBuffer.append("I/O error: ");
                stringBuffer.append(this.info);
                break;
            }
            case 2: {
                stringBuffer.append("unexpected end of file");
                break;
            }
            case 3: {
                stringBuffer.append("unexpected character '");
                stringBuffer.append(this.info);
                stringBuffer.append("'");
                break;
            }
            case 4: {
                stringBuffer.append("unexpected token ");
                stringBuffer.append(this.info);
                if (this.details == null) break;
                stringBuffer.append(", expected ");
                if (this.details.size() > 1) {
                    stringBuffer.append("one of ");
                }
                stringBuffer.append(this.getMessageDetails());
                break;
            }
            case 5: {
                stringBuffer.append(this.info);
                break;
            }
            case 6: {
                stringBuffer.append(this.info);
                break;
            }
            default: {
                stringBuffer.append("internal error");
                if (this.info == null) break;
                stringBuffer.append(": ");
                stringBuffer.append(this.info);
            }
        }
        return stringBuffer.toString();
    }

    private String getMessageDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.details.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
                if (i + 1 == this.details.size()) {
                    stringBuffer.append("or ");
                }
            }
            stringBuffer.append(this.details.get(i));
        }
        return stringBuffer.toString();
    }
}

