/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;

public abstract class Node {
    private Node parent = null;
    private ArrayList values = null;

    boolean isHidden() {
        return false;
    }

    public abstract int getId();

    public abstract String getName();

    public int getStartLine() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n = this.getChildAt(i).getStartLine();
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public int getStartColumn() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n = this.getChildAt(i).getStartColumn();
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public int getEndLine() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            int n = this.getChildAt(i).getEndLine();
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public int getEndColumn() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            int n = this.getChildAt(i).getEndColumn();
            if (n < 0) continue;
            return n;
        }
        return -1;
    }

    public Node getParent() {
        return this.parent;
    }

    void setParent(Node node) {
        this.parent = node;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getChildAt(int n) {
        return null;
    }

    public int getDescendantCount() {
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            n += 1 + this.getChildAt(i).getDescendantCount();
        }
        return n;
    }

    public int getValueCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    public Object getValue(int n) {
        if (this.values == null || n < 0 || n >= this.values.size()) {
            return null;
        }
        return this.values.get(n);
    }

    public ArrayList getAllValues() {
        return this.values;
    }

    public void addValue(Object object) {
        if (object != null) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(object);
        }
    }

    public void addValues(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addValue(vector.get(i));
            }
        }
    }

    public void addValues(ArrayList arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.addValue(arrayList.get(i));
            }
        }
    }

    public void removeAllValues() {
        this.values = null;
    }

    public void printTo(PrintStream printStream) {
        this.printTo(new PrintWriter(printStream));
    }

    public void printTo(PrintWriter printWriter) {
        this.printTo(printWriter, "");
        printWriter.flush();
    }

    private void printTo(PrintWriter printWriter, String string) {
        printWriter.println(string + this.toString());
        string = string + "  ";
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).printTo(printWriter, string);
        }
    }
}

