/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

class LookAheadSet {
    private ArrayList elements = new ArrayList();
    private int maxLength;

    public LookAheadSet(int n) {
        this.maxLength = n;
    }

    public LookAheadSet(int n, LookAheadSet lookAheadSet) {
        this(n);
        this.addAll(lookAheadSet);
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public int getMinLength() {
        int n = -1;
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (n >= 0 && sequence.length() >= n) continue;
            n = sequence.length();
        }
        return n < 0 ? 0 : n;
    }

    public int getMaxLength() {
        int n = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (sequence.length() <= n) continue;
            n = sequence.length();
        }
        return n;
    }

    public int[] getInitialTokens() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.elements.size(); ++n) {
            Integer n2 = ((Sequence)this.elements.get(n)).getToken(0);
            if (n2 == null || arrayList.contains(n2)) continue;
            arrayList.add(n2);
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public boolean isRepetitive() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (!sequence.isRepetitive()) continue;
            return true;
        }
        return false;
    }

    public boolean isNext(Parser parser) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (!sequence.isNext(parser)) continue;
            return true;
        }
        return false;
    }

    public boolean isNext(Parser parser, int n) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (!sequence.isNext(parser, n)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOverlap(LookAheadSet lookAheadSet) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!lookAheadSet.hasOverlap((Sequence)this.elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasOverlap(Sequence sequence) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence2 = (Sequence)this.elements.get(i);
            if (!sequence.startsWith(sequence2) && !sequence2.startsWith(sequence)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntersection(LookAheadSet lookAheadSet) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!lookAheadSet.contains((Sequence)this.elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Sequence sequence) {
        return this.findSequence(sequence) != null;
    }

    private Sequence findSequence(Sequence sequence) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).equals(sequence)) continue;
            return (Sequence)this.elements.get(i);
        }
        return null;
    }

    private void add(Sequence sequence) {
        if (sequence.length() > this.maxLength) {
            sequence = new Sequence(this.maxLength, sequence);
        }
        if (!this.contains(sequence)) {
            this.elements.add(sequence);
        }
    }

    public void add(int n) {
        this.add(new Sequence(false, n));
    }

    public void addAll(LookAheadSet lookAheadSet) {
        for (int i = 0; i < lookAheadSet.elements.size(); ++i) {
            this.add((Sequence)lookAheadSet.elements.get(i));
        }
    }

    public void addEmpty() {
        this.add(new Sequence());
    }

    private void remove(Sequence sequence) {
        this.elements.remove(sequence);
    }

    public void removeAll(LookAheadSet lookAheadSet) {
        for (int i = 0; i < lookAheadSet.elements.size(); ++i) {
            this.remove((Sequence)lookAheadSet.elements.get(i));
        }
    }

    public LookAheadSet createNextSet(int n) {
        LookAheadSet lookAheadSet = new LookAheadSet(this.maxLength - 1);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            Integer n2 = sequence.getToken(0);
            if (n2 == null || n2 != n) continue;
            lookAheadSet.add(sequence.subsequence(1));
        }
        return lookAheadSet;
    }

    public LookAheadSet createIntersection(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            Sequence sequence2 = lookAheadSet.findSequence(sequence);
            if (sequence2 != null && sequence.isRepetitive()) {
                lookAheadSet2.add(sequence2);
                continue;
            }
            if (sequence2 == null) continue;
            lookAheadSet2.add(sequence);
        }
        return lookAheadSet2;
    }

    public LookAheadSet createCombination(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        if (this.isEmpty()) {
            return lookAheadSet;
        }
        if (lookAheadSet.isEmpty()) {
            return this;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (sequence.length() >= this.maxLength) {
                lookAheadSet2.add(sequence);
                continue;
            }
            if (sequence.length() <= 0) {
                lookAheadSet2.addAll(lookAheadSet);
                continue;
            }
            for (int j = 0; j < lookAheadSet.elements.size(); ++j) {
                Sequence sequence2 = (Sequence)lookAheadSet.elements.get(j);
                lookAheadSet2.add(sequence.concat(this.maxLength, sequence2));
            }
        }
        return lookAheadSet2;
    }

    public LookAheadSet createOverlaps(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (!lookAheadSet.hasOverlap(sequence)) continue;
            lookAheadSet2.add(sequence);
        }
        return lookAheadSet2;
    }

    public LookAheadSet createFilter(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        if (this.isEmpty() || lookAheadSet.isEmpty()) {
            return this;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            for (int j = 0; j < lookAheadSet.elements.size(); ++j) {
                Sequence sequence2 = (Sequence)lookAheadSet.elements.get(j);
                if (!sequence.startsWith(sequence2)) continue;
                lookAheadSet2.add(sequence.subsequence(sequence2.length()));
            }
        }
        return lookAheadSet2;
    }

    public LookAheadSet createRepetitive() {
        LookAheadSet lookAheadSet = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            if (sequence.isRepetitive()) {
                lookAheadSet.add(sequence);
                continue;
            }
            lookAheadSet.add(new Sequence(true, sequence));
        }
        return lookAheadSet;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Tokenizer tokenizer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence sequence = (Sequence)this.elements.get(i);
            stringBuffer.append("\n  ");
            stringBuffer.append(sequence.toString(tokenizer));
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private class Sequence {
        private boolean repeat = false;
        private ArrayList tokens = null;

        public Sequence() {
            this.repeat = false;
            this.tokens = new ArrayList(0);
        }

        public Sequence(boolean bl, int n) {
            this.repeat = false;
            this.tokens = new ArrayList(1);
            this.tokens.add(new Integer(n));
        }

        public Sequence(int n, Sequence sequence) {
            this.repeat = sequence.repeat;
            this.tokens = new ArrayList(n);
            if (sequence.length() < n) {
                n = sequence.length();
            }
            for (int i = 0; i < n; ++i) {
                this.tokens.add(sequence.tokens.get(i));
            }
        }

        public Sequence(boolean bl, Sequence sequence) {
            this.repeat = bl;
            this.tokens = sequence.tokens;
        }

        public int length() {
            return this.tokens.size();
        }

        public Integer getToken(int n) {
            if (n >= 0 && n < this.tokens.size()) {
                return (Integer)this.tokens.get(n);
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof Sequence) {
                return this.tokens.equals(((Sequence)object).tokens);
            }
            return false;
        }

        public int hashCode() {
            return this.tokens.hashCode();
        }

        public boolean startsWith(Sequence sequence) {
            if (this.length() < sequence.length()) {
                return false;
            }
            for (int i = 0; i < sequence.tokens.size(); ++i) {
                if (this.tokens.get(i).equals(sequence.tokens.get(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isRepetitive() {
            return this.repeat;
        }

        public boolean isNext(Parser parser) {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Integer n = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token != null && token.getId() == n.intValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isNext(Parser parser, int n) {
            if (n > this.tokens.size()) {
                n = this.tokens.size();
            }
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token != null && token.getId() == n2.intValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Tokenizer tokenizer) {
            StringBuffer stringBuffer = new StringBuffer();
            if (tokenizer == null) {
                stringBuffer.append(this.tokens.toString());
            } else {
                stringBuffer.append("[");
                for (int i = 0; i < this.tokens.size(); ++i) {
                    Integer n = (Integer)this.tokens.get(i);
                    String string = tokenizer.getPatternDescription(n);
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string);
                }
                stringBuffer.append("]");
            }
            if (this.repeat) {
                stringBuffer.append(" *");
            }
            return stringBuffer.toString();
        }

        public Sequence concat(int n, Sequence sequence) {
            Sequence sequence2 = new Sequence(n, this);
            if (sequence.repeat) {
                sequence2.repeat = true;
            }
            if ((n -= this.length()) > sequence.length()) {
                sequence2.tokens.addAll(sequence.tokens);
            } else {
                for (int i = 0; i < n; ++i) {
                    sequence2.tokens.add(sequence.tokens.get(i));
                }
            }
            return sequence2;
        }

        public Sequence subsequence(int n) {
            Sequence sequence = new Sequence(this.length(), this);
            while (n > 0 && sequence.tokens.size() > 0) {
                sequence.tokens.remove(0);
                --n;
            }
            return sequence;
        }
    }
}

