/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;

public class Analyzer {
    public void reset() {
    }

    public Node analyze(Node node) throws ParserLogException {
        ParserLogException parserLogException = new ParserLogException();
        node = this.analyze(node, parserLogException);
        if (parserLogException.getErrorCount() > 0) {
            throw parserLogException;
        }
        return node;
    }

    private Node analyze(Node node, ParserLogException parserLogException) {
        block13: {
            int n = parserLogException.getErrorCount();
            if (node instanceof Production) {
                Production production = (Production)node;
                production = this.newProduction(production.getPattern());
                try {
                    this.enter(production);
                }
                catch (ParseException parseException) {
                    parserLogException.addError(parseException);
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    try {
                        this.child(production, this.analyze(node.getChildAt(i), parserLogException));
                        continue;
                    }
                    catch (ParseException parseException) {
                        parserLogException.addError(parseException);
                    }
                }
                try {
                    return this.exit(production);
                }
                catch (ParseException parseException) {
                    if (n == parserLogException.getErrorCount()) {
                        parserLogException.addError(parseException);
                    }
                    break block13;
                }
            }
            node.removeAllValues();
            try {
                this.enter(node);
            }
            catch (ParseException parseException) {
                parserLogException.addError(parseException);
            }
            try {
                return this.exit(node);
            }
            catch (ParseException parseException) {
                if (n != parserLogException.getErrorCount()) break block13;
                parserLogException.addError(parseException);
            }
        }
        return null;
    }

    protected Production newProduction(ProductionPattern productionPattern) {
        return new Production(productionPattern);
    }

    protected void enter(Node node) throws ParseException {
    }

    protected Node exit(Node node) throws ParseException {
        return node;
    }

    protected void child(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected Node getChildAt(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Node node2 = node.getChildAt(n);
        if (node2 == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no child at " + "position " + n, node.getStartLine(), node.getStartColumn());
        }
        return node2;
    }

    protected Node getChildWithId(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChildAt(i);
            if (node2 == null || node2.getId() != n) continue;
            return node2;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no child with id " + n, node.getStartLine(), node.getStartColumn());
    }

    protected Object getValue(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Object object = node.getValue(n);
        if (object == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no value at " + "position " + n, node.getStartLine(), node.getStartColumn());
        }
        return object;
    }

    protected int getIntValue(Node node, int n) throws ParseException {
        Object object = this.getValue(node, n);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no integer value " + "at position " + n, node.getStartLine(), node.getStartColumn());
    }

    protected String getStringValue(Node node, int n) throws ParseException {
        Object object = this.getValue(node, n);
        if (object instanceof String) {
            return (String)object;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no string value " + "at position " + n, node.getStartLine(), node.getStartColumn());
    }

    protected ArrayList getChildValues(Node node) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = node.getChildAt(i);
            ArrayList arrayList2 = node2.getAllValues();
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }
}

