/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicConstructor;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicTokenizerFile {
    private static final String TYPE_COMMENT = "<remarks>A character stream tokenizer.</remarks>";
    private static final String CONSTRUCTOR_COMMENT = "<summary>Creates a new tokenizer for the specified input\nstream.</summary>\n\n<param name='input'>the input stream to read</param>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the tokenizer by creating all the token\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicMethod initMethod;

    public VisualBasicTokenizerFile(VisualBasicParserGenerator visualBasicParserGenerator) {
        String string = visualBasicParserGenerator.getBaseName() + "Tokenizer";
        this.gen = visualBasicParserGenerator;
        this.file = new VisualBasicFile(visualBasicParserGenerator.getBaseDir(), string);
        int n = visualBasicParserGenerator.getPublicAccess() ? 1 : 4;
        this.cls = new VisualBasicClass(n, string, "Tokenizer");
        this.initMethod = new VisualBasicMethod(5, "CreatePatterns", "", "");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImports(new VisualBasicImports("System.IO"));
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace visualBasicNamespace = new VisualBasicNamespace(this.gen.getNamespace());
            visualBasicNamespace.addClass(this.cls);
            this.file.addNamespace(visualBasicNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, string));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        VisualBasicConstructor visualBasicConstructor = new VisualBasicConstructor("ByVal input As TextReader");
        this.cls.addConstructor(visualBasicConstructor);
        visualBasicConstructor.addComment(new VisualBasicComment(CONSTRUCTOR_COMMENT));
        visualBasicConstructor.addCode("MyBase.New(input, " + this.getBoolean(!this.gen.getGrammar().getCaseSensitive()) + ")");
        visualBasicConstructor.addCode("CreatePatterns()");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new VisualBasicComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("Dim pattern as TokenPattern");
    }

    public void addToken(TokenPattern tokenPattern, VisualBasicConstantsFile visualBasicConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = New TokenPattern(CInt(");
        stringBuffer.append(visualBasicConstantsFile.getConstant(tokenPattern.getId()));
        stringBuffer.append("), \"");
        stringBuffer.append(tokenPattern.getName());
        stringBuffer.append("\", TokenPattern.PatternType.");
        switch (tokenPattern.getType()) {
            case 1: {
                stringBuffer.append("STRING");
                break;
            }
            case 2: {
                stringBuffer.append("REGEXP");
            }
        }
        stringBuffer.append(", ");
        String string = tokenPattern.getPattern();
        stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\"'));
        stringBuffer.append(")\n");
        if (tokenPattern.isError()) {
            if (tokenPattern.getErrorMessage() == null) {
                stringBuffer.append("pattern.Error = True");
            } else {
                stringBuffer.append("pattern.ErrorMessage = ");
                string = tokenPattern.getErrorMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\"'));
            }
            stringBuffer.append("\n");
        }
        if (tokenPattern.isIgnore()) {
            if (tokenPattern.getIgnoreMessage() == null) {
                stringBuffer.append("pattern.Ignore = True");
            } else {
                stringBuffer.append("pattern.IgnoreMessage = ");
                string = tokenPattern.getIgnoreMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\"'));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("AddPattern(pattern)");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    private String getBoolean(boolean bl) {
        return bl ? "True" : "False";
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

