/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.output.VisualBasicAnalyzerFile;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserFile;
import net.percederberg.grammatica.output.VisualBasicTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class VisualBasicParserGenerator
extends ParserGenerator {
    private String baseName = null;
    private String namespace = null;
    private boolean publicAccess = false;

    public VisualBasicParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String string = this.getGrammar().getFileName();
        if (string.indexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        if (string.indexOf(92) >= 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.indexOf(46));
        }
        if (Character.isLowerCase(string.charAt(0))) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        this.baseName = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public boolean getPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean bl) {
        this.publicAccess = bl;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.VISUAL_BASIC;
    }

    public void write() throws IOException {
        ProductionPattern productionPattern;
        int n;
        Grammar grammar = this.getGrammar();
        VisualBasicConstantsFile visualBasicConstantsFile = new VisualBasicConstantsFile(this);
        VisualBasicTokenizerFile visualBasicTokenizerFile = new VisualBasicTokenizerFile(this);
        VisualBasicAnalyzerFile visualBasicAnalyzerFile = new VisualBasicAnalyzerFile(this);
        VisualBasicParserFile visualBasicParserFile = new VisualBasicParserFile(this, visualBasicTokenizerFile, visualBasicAnalyzerFile);
        for (n = 0; n < grammar.getTokenPatternCount(); ++n) {
            TokenPattern tokenPattern = grammar.getTokenPattern(n);
            visualBasicConstantsFile.addToken(tokenPattern);
            visualBasicTokenizerFile.addToken(tokenPattern, visualBasicConstantsFile);
            visualBasicAnalyzerFile.addToken(tokenPattern, visualBasicConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            visualBasicConstantsFile.addProduction(productionPattern);
            visualBasicParserFile.addProductionConstant(productionPattern);
            visualBasicAnalyzerFile.addProduction(productionPattern, visualBasicConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            visualBasicParserFile.addProduction(productionPattern, visualBasicConstantsFile);
        }
        visualBasicConstantsFile.writeCode();
        visualBasicTokenizerFile.writeCode();
        visualBasicParserFile.writeCode();
        visualBasicAnalyzerFile.writeCode();
    }
}

