/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicConstructor;
import net.percederberg.grammatica.code.visualbasic.VisualBasicEnumeration;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicAnalyzerFile;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.output.VisualBasicTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;

class VisualBasicParserFile {
    private static final String TYPE_COMMENT = "<remarks>A token stream parser.</remarks>";
    private static final String ENUM_COMMENT = "<summary>An enumeration with the generated production node\nidentity constants.</summary>";
    private static final String CONSTRUCTOR1_COMMENT = "<summary>Creates a new parser with a default analyzer.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String CONSTRUCTOR2_COMMENT = "<summary>Creates a new parser.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<param name='analyzer'>the analyzer to parse with</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String FACTORY_COMMENT = "<summary>Creates a new tokenizer for this parser. Can be overridden\nby a subclass to provide a custom implementation.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<returns>the tokenizer created</returns>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the parser by creating all the production\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicEnumeration enm;
    private VisualBasicMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public VisualBasicParserFile(VisualBasicParserGenerator visualBasicParserGenerator, VisualBasicTokenizerFile visualBasicTokenizerFile, VisualBasicAnalyzerFile visualBasicAnalyzerFile) {
        String string = visualBasicParserGenerator.getBaseName() + "Parser";
        this.gen = visualBasicParserGenerator;
        this.file = new VisualBasicFile(visualBasicParserGenerator.getBaseDir(), string);
        int n = visualBasicParserGenerator.getPublicAccess() ? 1 : 4;
        this.cls = new VisualBasicClass(n, string, "RecursiveDescentParser");
        this.enm = new VisualBasicEnumeration(5, "SynteticPatterns");
        this.initMethod = new VisualBasicMethod(5, "CreatePatterns", "", "");
        this.initializeCode(visualBasicTokenizerFile, visualBasicAnalyzerFile);
    }

    private void initializeCode(VisualBasicTokenizerFile visualBasicTokenizerFile, VisualBasicAnalyzerFile visualBasicAnalyzerFile) {
        this.file.addImports(new VisualBasicImports("System.IO"));
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace visualBasicNamespace = new VisualBasicNamespace(this.gen.getNamespace());
            visualBasicNamespace.addClass(this.cls);
            this.file.addNamespace(visualBasicNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, string));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        this.cls.addEnumeration(this.enm);
        this.enm.addComment(new VisualBasicComment(ENUM_COMMENT));
        VisualBasicConstructor visualBasicConstructor = new VisualBasicConstructor("ByVal input As TextReader");
        this.cls.addConstructor(visualBasicConstructor);
        visualBasicConstructor.addComment(new VisualBasicComment(CONSTRUCTOR1_COMMENT));
        visualBasicConstructor.addCode("MyBase.New(input)");
        visualBasicConstructor.addCode("CreatePatterns()");
        visualBasicConstructor = new VisualBasicConstructor("ByVal input As TextReader, ByVal analyzer As " + visualBasicAnalyzerFile.getClassName());
        this.cls.addConstructor(visualBasicConstructor);
        visualBasicConstructor.addComment(new VisualBasicComment(CONSTRUCTOR2_COMMENT));
        visualBasicConstructor.addCode("MyBase.New(input, analyzer)");
        visualBasicConstructor.addCode("CreatePatterns()");
        VisualBasicMethod visualBasicMethod = new VisualBasicMethod(515, "NewTokenizer", "ByVal input As TextReader", "Tokenizer");
        visualBasicMethod.addComment(new VisualBasicComment(FACTORY_COMMENT));
        visualBasicMethod.addCode("Return New " + visualBasicTokenizerFile.getClassName() + "(input);");
        this.cls.addMethod(visualBasicMethod);
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new VisualBasicComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("Dim pattern As ProductionPattern");
        this.initMethod.addCode("Dim alt As ProductionPatternAlternative");
    }

    public void addProductionConstant(ProductionPattern productionPattern) {
        if (productionPattern.isSynthetic()) {
            String string = "SUBPRODUCTION_" + this.constantId;
            this.enm.addConstant(string, String.valueOf(this.constantId + 3000));
            this.constantNames.put(new Integer(productionPattern.getId()), string);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern productionPattern, VisualBasicConstantsFile visualBasicConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = New ProductionPattern(CInt(");
        stringBuffer.append(this.getConstant(visualBasicConstantsFile, productionPattern.getId()));
        stringBuffer.append("), \"");
        if (productionPattern.isSynthetic()) {
            String string = (String)this.constantNames.get(new Integer(productionPattern.getId()));
            stringBuffer.append(this.gen.getCodeStyle().getMixedCase(string, true));
        } else {
            stringBuffer.append(productionPattern.getName());
        }
        stringBuffer.append("\")");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
        if (productionPattern.isSynthetic()) {
            this.initMethod.addCode("pattern.Synthetic = True");
        }
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            this.addProductionAlternative(productionPattern.getAlternative(i), visualBasicConstantsFile);
        }
        this.initMethod.addCode("AddPattern(pattern)");
    }

    private void addProductionAlternative(ProductionPatternAlternative productionPatternAlternative, VisualBasicConstantsFile visualBasicConstantsFile) {
        this.initMethod.addCode("alt = New ProductionPatternAlternative()");
        for (int i = 0; i < productionPatternAlternative.getElementCount(); ++i) {
            ProductionPatternElement productionPatternElement = productionPatternAlternative.getElement(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("alt.");
            if (productionPatternElement.isToken()) {
                stringBuffer.append("AddToken(");
            } else {
                stringBuffer.append("AddProduction(");
            }
            stringBuffer.append("CInt(");
            stringBuffer.append(this.getConstant(visualBasicConstantsFile, productionPatternElement.getId()));
            stringBuffer.append("), ");
            stringBuffer.append(productionPatternElement.getMinCount());
            stringBuffer.append(", ");
            if (productionPatternElement.getMaxCount() == Integer.MAX_VALUE) {
                stringBuffer.append("-1");
            } else {
                stringBuffer.append(productionPatternElement.getMaxCount());
            }
            stringBuffer.append(")");
            this.initMethod.addCode(stringBuffer.toString());
        }
        this.initMethod.addCode("pattern.AddAlternative(alt)");
    }

    private String getConstant(VisualBasicConstantsFile visualBasicConstantsFile, int n) {
        Integer n2 = new Integer(n);
        if (this.constantNames.containsKey(n2)) {
            return "SynteticPatterns." + this.constantNames.get(n2);
        }
        return visualBasicConstantsFile.getConstant(n);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

