/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicEnumeration;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicConstantsFile {
    private static final String TYPE_COMMENT = "<remarks>An enumeration with token and production node\nconstants.</remarks>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicEnumeration enm;
    private HashMap constantNames = new HashMap();

    public VisualBasicConstantsFile(VisualBasicParserGenerator visualBasicParserGenerator) {
        String string = visualBasicParserGenerator.getBaseName() + "Constants";
        this.gen = visualBasicParserGenerator;
        this.file = new VisualBasicFile(visualBasicParserGenerator.getBaseDir(), string);
        int n = visualBasicParserGenerator.getPublicAccess() ? 1 : 4;
        this.enm = new VisualBasicEnumeration(n, string);
        this.initializeCode();
    }

    private void initializeCode() {
        if (this.gen.getNamespace() == null) {
            this.file.addEnumeration(this.enm);
        } else {
            VisualBasicNamespace visualBasicNamespace = new VisualBasicNamespace(this.gen.getNamespace());
            visualBasicNamespace.addEnumeration(this.enm);
            this.file.addNamespace(visualBasicNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, string));
        this.enm.addComment(new VisualBasicComment(TYPE_COMMENT));
    }

    public void addToken(TokenPattern tokenPattern) {
        String string = this.gen.getCodeStyle().getUpperCase(tokenPattern.getName());
        this.enm.addConstant(string, String.valueOf(tokenPattern.getId()));
        this.constantNames.put(new Integer(tokenPattern.getId()), string);
    }

    public void addProduction(ProductionPattern productionPattern) {
        if (!productionPattern.isSynthetic()) {
            String string = this.gen.getCodeStyle().getUpperCase(productionPattern.getName());
            this.enm.addConstant(string, String.valueOf(productionPattern.getId()));
            this.constantNames.put(new Integer(productionPattern.getId()), string);
        }
    }

    public String getConstant(int n) {
        String string = (String)this.constantNames.get(new Integer(n));
        if (string == null) {
            return null;
        }
        return this.enm.toString() + "." + string;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

