/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicAnalyzerFile {
    private static final String TYPE_COMMENT = "<remarks>A class providing callback methods for the\nparser.</remarks>";
    private static final String ENTER_COMMENT = "<summary>Called when entering a parse tree node.</summary>\n\n<param name='node'>the node being entered</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String EXIT_COMMENT = "<summary>Called when exiting a parse tree node.</summary>\n\n<param name='node'>the node being exited</param>\n\n<returns>the node to add to the parse tree, or\n         null if no parse tree should be created</returns>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String CHILD_COMMENT = "<summary>Called when adding a child to a parse tree\nnode.</summary>\n\n<param name='node'>the parent node</param>\n<param name='child'>the child node, or null</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicMethod enter;
    private VisualBasicMethod exit;
    private VisualBasicMethod child;

    public VisualBasicAnalyzerFile(VisualBasicParserGenerator visualBasicParserGenerator) {
        String string = visualBasicParserGenerator.getBaseName() + "Analyzer";
        this.gen = visualBasicParserGenerator;
        this.file = new VisualBasicFile(visualBasicParserGenerator.getBaseDir(), string);
        int n = 8;
        n = visualBasicParserGenerator.getPublicAccess() ? ++n : (n += 4);
        this.cls = new VisualBasicClass(n, string, "Analyzer");
        n = 513;
        this.enter = new VisualBasicMethod(n, "Enter", "ByVal node As Node", "");
        this.exit = new VisualBasicMethod(n, "[Exit]", "ByVal node As Node", "Node");
        this.child = new VisualBasicMethod(n, "Child", "ByVal node As Production, ByVal child As Node", "");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace visualBasicNamespace = new VisualBasicNamespace(this.gen.getNamespace());
            visualBasicNamespace.addClass(this.cls);
            this.file.addNamespace(visualBasicNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, string));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        this.enter.addComment(new VisualBasicComment(ENTER_COMMENT));
        this.enter.addCode("Select Case node.Id");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new VisualBasicComment(EXIT_COMMENT));
        this.exit.addCode("Select Case node.Id");
        this.cls.addMethod(this.exit);
        this.child.addComment(new VisualBasicComment(CHILD_COMMENT));
        this.child.addCode("Select Case node.Id");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern tokenPattern, VisualBasicConstantsFile visualBasicConstantsFile) {
        String string = visualBasicConstantsFile.getConstant(tokenPattern.getId());
        if (!tokenPattern.isIgnore()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(tokenPattern.getName(), true);
            this.addEnterCase(string, string2, "Token");
            this.addEnterMethod(string2, "Token");
            this.addExitCase(string, string2, "Token");
            this.addExitMethod(string2, "Token");
        }
    }

    public void addProduction(ProductionPattern productionPattern, VisualBasicConstantsFile visualBasicConstantsFile) {
        String string = visualBasicConstantsFile.getConstant(productionPattern.getId());
        if (!productionPattern.isSynthetic()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(productionPattern.getName(), true);
            this.addEnterCase(string, string2, "Production");
            this.addEnterMethod(string2, "Production");
            this.addExitCase(string, string2, "Production");
            this.addExitMethod(string2, "Production");
            this.addChildCase(string, string2);
            this.addChildMethod(string2);
        }
    }

    private void addEnterCase(String string, String string2, String string3) {
        this.enter.addCode("Case " + string);
        this.enter.addCode("    Enter" + string2 + "(CType(node," + string3 + "))");
        this.enter.addCode("");
    }

    private void addExitCase(String string, String string2, String string3) {
        this.exit.addCode("Case " + string);
        this.exit.addCode("    return Exit" + string2 + "(CType(node," + string3 + "))");
        this.exit.addCode("");
    }

    private void addChildCase(String string, String string2) {
        this.child.addCode("Case " + string);
        this.child.addCode("    Child" + string2 + "(node, child)");
        this.child.addCode("");
    }

    private void addEnterMethod(String string, String string2) {
        VisualBasicMethod visualBasicMethod = new VisualBasicMethod(129, "Enter" + string, "ByVal node As " + string2, "");
        visualBasicMethod.addComment(new VisualBasicComment(ENTER_COMMENT));
        this.cls.addMethod(visualBasicMethod);
    }

    private void addExitMethod(String string, String string2) {
        VisualBasicMethod visualBasicMethod = new VisualBasicMethod(129, "Exit" + string, "ByVal node As " + string2, "Node");
        visualBasicMethod.addComment(new VisualBasicComment(EXIT_COMMENT));
        visualBasicMethod.addCode("Return node");
        this.cls.addMethod(visualBasicMethod);
    }

    private void addChildMethod(String string) {
        VisualBasicMethod visualBasicMethod = new VisualBasicMethod(129, "Child" + string, "ByVal node As Production, ByVal child As Node", "");
        visualBasicMethod.addComment(new VisualBasicComment(CHILD_COMMENT));
        visualBasicMethod.addCode("node.AddChild(child)");
        this.cls.addMethod(visualBasicMethod);
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.enter.addCode("End Select");
        this.exit.addCode("End Select");
        this.exit.addCode("Return node");
        this.child.addCode("End Select");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

