/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaConstructor;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaTokenizerFile {
    private static final String CLASS_COMMENT = "A character stream tokenizer.";
    private static final String CONSTRUCTOR_COMMENT = "Creates a new tokenizer for the specified input stream.\n\n@param input          the input stream to read\n\n@throws ParserCreationException if the tokenizer couldn't be\n            initialized correctly";
    private static final String INIT_METHOD_COMMENT = "Initializes the tokenizer by creating all the token patterns.\n\n@throws ParserCreationException if the tokenizer couldn't be\n            initialized correctly";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod initMethod;

    public JavaTokenizerFile(JavaParserGenerator javaParserGenerator) {
        this.gen = javaParserGenerator;
        this.file = javaParserGenerator.createJavaFile();
        int n = javaParserGenerator.getPublicAccess() ? 0 : 2;
        this.cls = new JavaClass(n, javaParserGenerator.getBaseName() + "Tokenizer", "Tokenizer");
        this.initMethod = new JavaMethod(3, "createPatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImport(new JavaImport("java.io", "Reader"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParserCreationException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "TokenPattern"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Tokenizer"));
        this.file.addClass(this.cls);
        String string = CLASS_COMMENT;
        if (this.gen.getClassComment() != null) {
            string = string + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(string));
        string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, string));
        JavaConstructor javaConstructor = new JavaConstructor("Reader input");
        this.cls.addConstructor(javaConstructor);
        javaConstructor.addComment(new JavaComment(CONSTRUCTOR_COMMENT));
        javaConstructor.addThrows("ParserCreationException");
        javaConstructor.addCode("super(input, " + !this.gen.getGrammar().getCaseSensitive() + ");");
        javaConstructor.addCode("createPatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new JavaComment(INIT_METHOD_COMMENT));
        this.initMethod.addThrows("ParserCreationException");
        this.initMethod.addCode("TokenPattern  pattern;");
    }

    public void addToken(TokenPattern tokenPattern, JavaConstantsFile javaConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = new TokenPattern(");
        stringBuffer.append(javaConstantsFile.getConstant(tokenPattern.getId()));
        stringBuffer.append(",\n");
        stringBuffer.append("                           \"");
        stringBuffer.append(tokenPattern.getName());
        stringBuffer.append("\",\n");
        stringBuffer.append("                           TokenPattern.");
        switch (tokenPattern.getType()) {
            case 1: {
                stringBuffer.append("STRING_TYPE");
                break;
            }
            case 2: {
                stringBuffer.append("REGEXP_TYPE");
            }
        }
        stringBuffer.append(",\n");
        stringBuffer.append("                           ");
        String string = tokenPattern.getPattern();
        stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
        stringBuffer.append(");\n");
        if (tokenPattern.isError()) {
            stringBuffer.append("pattern.setError(");
            if (tokenPattern.getErrorMessage() != null) {
                string = tokenPattern.getErrorMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
            }
            stringBuffer.append(");\n");
        }
        if (tokenPattern.isIgnore()) {
            stringBuffer.append("pattern.setIgnore(");
            if (tokenPattern.getIgnoreMessage() != null) {
                string = tokenPattern.getIgnoreMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
            }
            stringBuffer.append(");\n");
        }
        stringBuffer.append("addPattern(pattern);");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

