/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaPackage;
import net.percederberg.grammatica.output.JavaAnalyzerFile;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserFile;
import net.percederberg.grammatica.output.JavaTokenizerFile;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class JavaParserGenerator
extends ParserGenerator {
    private String basePackage = null;
    private String baseName = null;
    private boolean publicAccess = false;
    private String classComment = null;

    public JavaParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String string = this.getGrammar().getFileName();
        if (string.indexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        if (string.indexOf(92) >= 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.indexOf(46));
        }
        if (Character.isLowerCase(string.charAt(0))) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        this.baseName = string;
        StringBuffer stringBuffer = new StringBuffer();
        string = this.getGrammar().getDeclaration("AUTHOR");
        if (string != null) {
            stringBuffer.append("@author   ");
            stringBuffer.append(string);
        }
        if ((string = this.getGrammar().getDeclaration("VERSION")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("@version  ");
            stringBuffer.append(string);
        }
        this.classComment = stringBuffer.toString();
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String string) {
        this.basePackage = string;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public boolean getPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean bl) {
        this.publicAccess = bl;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.JAVA;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public void write() throws IOException {
        ProductionPattern productionPattern;
        int n;
        Grammar grammar = this.getGrammar();
        JavaConstantsFile javaConstantsFile = new JavaConstantsFile(this);
        JavaTokenizerFile javaTokenizerFile = new JavaTokenizerFile(this);
        JavaAnalyzerFile javaAnalyzerFile = new JavaAnalyzerFile(this);
        JavaParserFile javaParserFile = new JavaParserFile(this, javaTokenizerFile, javaAnalyzerFile);
        for (n = 0; n < grammar.getTokenPatternCount(); ++n) {
            TokenPattern tokenPattern = grammar.getTokenPattern(n);
            javaConstantsFile.addToken(tokenPattern);
            javaTokenizerFile.addToken(tokenPattern, javaConstantsFile);
            javaAnalyzerFile.addToken(tokenPattern, javaConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            javaConstantsFile.addProduction(productionPattern);
            javaParserFile.addProductionConstant(productionPattern);
            javaAnalyzerFile.addProduction(productionPattern, javaConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            javaParserFile.addProduction(productionPattern, javaConstantsFile);
        }
        javaConstantsFile.writeCode();
        javaTokenizerFile.writeCode();
        javaParserFile.writeCode();
        javaAnalyzerFile.writeCode();
    }

    public JavaFile createJavaFile() {
        if (this.basePackage == null) {
            return new JavaFile(this.getBaseDir());
        }
        return new JavaFile(this.getBaseDir(), new JavaPackage(this.getBasePackage()));
    }
}

