/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaConstructor;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.code.java.JavaVariable;
import net.percederberg.grammatica.output.JavaAnalyzerFile;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.output.JavaTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;

class JavaParserFile {
    private static final String TYPE_COMMENT = "A token stream parser.";
    private static final String PRODUCTION_COMMENT = "A generated production node identity constant.";
    private static final String CONSTRUCTOR1_COMMENT = "Creates a new parser with a default analyzer.\n\n@param in             the input stream to read from\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private static final String CONSTRUCTOR2_COMMENT = "Creates a new parser.\n\n@param in             the input stream to read from\n@param analyzer       the analyzer to use while parsing\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private static final String FACTORY_COMMENT = "Creates a new tokenizer for this parser. Can be overridden by a\nsubclass to provide a custom implementation.\n\n@param in             the input stream to read from\n\n@return the tokenizer created\n\n@throws ParserCreationException if the tokenizer couldn't be\n            initialized correctly";
    private static final String INIT_METHOD_COMMENT = "Initializes the parser by creating all the production patterns.\n\n@throws ParserCreationException if the parser couldn't be\n            initialized correctly";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public JavaParserFile(JavaParserGenerator javaParserGenerator, JavaTokenizerFile javaTokenizerFile, JavaAnalyzerFile javaAnalyzerFile) {
        this.gen = javaParserGenerator;
        this.file = javaParserGenerator.createJavaFile();
        int n = javaParserGenerator.getPublicAccess() ? 0 : 2;
        this.cls = new JavaClass(n, javaParserGenerator.getBaseName() + "Parser", "RecursiveDescentParser");
        this.initMethod = new JavaMethod(3, "createPatterns", "", "void");
        this.initializeCode(javaTokenizerFile, javaAnalyzerFile);
    }

    private void initializeCode(JavaTokenizerFile javaTokenizerFile, JavaAnalyzerFile javaAnalyzerFile) {
        this.file.addImport(new JavaImport("java.io", "Reader"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParserCreationException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ProductionPattern"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ProductionPatternAlternative"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "RecursiveDescentParser"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Tokenizer"));
        this.file.addClass(this.cls);
        String string = TYPE_COMMENT;
        if (this.gen.getClassComment() != null) {
            string = string + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(string));
        string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, string));
        JavaConstructor javaConstructor = new JavaConstructor("Reader in");
        this.cls.addConstructor(javaConstructor);
        javaConstructor.addComment(new JavaComment(CONSTRUCTOR1_COMMENT));
        javaConstructor.addThrows("ParserCreationException");
        javaConstructor.addCode("super(in);");
        javaConstructor.addCode("createPatterns();");
        javaConstructor = new JavaConstructor("Reader in, " + javaAnalyzerFile.getClassName() + " analyzer");
        this.cls.addConstructor(javaConstructor);
        javaConstructor.addComment(new JavaComment(CONSTRUCTOR2_COMMENT));
        javaConstructor.addThrows("ParserCreationException");
        javaConstructor.addCode("super(in, analyzer);");
        javaConstructor.addCode("createPatterns();");
        JavaMethod javaMethod = new JavaMethod(1, "newTokenizer", "Reader in", "Tokenizer");
        javaMethod.addThrows("ParserCreationException");
        javaMethod.addComment(new JavaComment(FACTORY_COMMENT));
        javaMethod.addCode("return new " + javaTokenizerFile.getClassName() + "(in);");
        this.cls.addMethod(javaMethod);
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new JavaComment(INIT_METHOD_COMMENT));
        this.initMethod.addThrows("ParserCreationException");
        this.initMethod.addCode("ProductionPattern             pattern;");
        this.initMethod.addCode("ProductionPatternAlternative  alt;");
    }

    public void addProductionConstant(ProductionPattern productionPattern) {
        if (productionPattern.isSynthetic()) {
            String string = "SUBPRODUCTION_" + this.constantId;
            int n = 23;
            JavaVariable javaVariable = new JavaVariable(n, "int", string, String.valueOf(this.constantId + 3000));
            javaVariable.addComment(new JavaComment(PRODUCTION_COMMENT));
            this.cls.addVariable(javaVariable);
            this.constantNames.put(new Integer(productionPattern.getId()), string);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern productionPattern, JavaConstantsFile javaConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = new ProductionPattern(");
        stringBuffer.append(this.getConstant(javaConstantsFile, productionPattern.getId()));
        stringBuffer.append(",\n");
        stringBuffer.append("                                \"");
        if (productionPattern.isSynthetic()) {
            String string = this.getConstant(javaConstantsFile, productionPattern.getId());
            stringBuffer.append(this.gen.getCodeStyle().getMixedCase(string, true));
        } else {
            stringBuffer.append(productionPattern.getName());
        }
        stringBuffer.append("\");");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
        if (productionPattern.isSynthetic()) {
            this.initMethod.addCode("pattern.setSynthetic(true);");
        }
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            this.addProductionAlternative(productionPattern.getAlternative(i), javaConstantsFile);
        }
        this.initMethod.addCode("addPattern(pattern);");
    }

    private void addProductionAlternative(ProductionPatternAlternative productionPatternAlternative, JavaConstantsFile javaConstantsFile) {
        this.initMethod.addCode("alt = new ProductionPatternAlternative();");
        for (int i = 0; i < productionPatternAlternative.getElementCount(); ++i) {
            ProductionPatternElement productionPatternElement = productionPatternAlternative.getElement(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("alt.");
            if (productionPatternElement.isToken()) {
                stringBuffer.append("addToken(");
            } else {
                stringBuffer.append("addProduction(");
            }
            stringBuffer.append(this.getConstant(javaConstantsFile, productionPatternElement.getId()));
            stringBuffer.append(", ");
            stringBuffer.append(productionPatternElement.getMinCount());
            stringBuffer.append(", ");
            if (productionPatternElement.getMaxCount() == Integer.MAX_VALUE) {
                stringBuffer.append("-1");
            } else {
                stringBuffer.append(productionPatternElement.getMaxCount());
            }
            stringBuffer.append(");");
            this.initMethod.addCode(stringBuffer.toString());
        }
        this.initMethod.addCode("pattern.addAlternative(alt);");
    }

    private String getConstant(JavaConstantsFile javaConstantsFile, int n) {
        Integer n2 = new Integer(n);
        if (this.constantNames.containsKey(n2)) {
            return (String)this.constantNames.get(n2);
        }
        return javaConstantsFile.getConstant(n);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

