/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaInterface;
import net.percederberg.grammatica.code.java.JavaVariable;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaConstantsFile {
    private static final String TYPE_COMMENT = "An interface with constants for the parser and tokenizer.";
    private static final String TOKEN_COMMENT = "A token identity constant.";
    private static final String PRODUCTION_COMMENT = "A production node identity constant.";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaInterface ifc;
    private HashMap constantNames = new HashMap();

    public JavaConstantsFile(JavaParserGenerator javaParserGenerator) {
        this.gen = javaParserGenerator;
        this.file = javaParserGenerator.createJavaFile();
        int n = javaParserGenerator.getPublicAccess() ? 0 : 2;
        this.ifc = new JavaInterface(n, javaParserGenerator.getBaseName() + "Constants");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addInterface(this.ifc);
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, string));
        string = TYPE_COMMENT;
        if (this.gen.getClassComment() != null) {
            string = string + "\n\n" + this.gen.getClassComment();
        }
        this.ifc.addComment(new JavaComment(string));
    }

    public void addToken(TokenPattern tokenPattern) {
        String string = this.gen.getCodeStyle().getUpperCase(tokenPattern.getName());
        int n = 20;
        JavaVariable javaVariable = new JavaVariable(n, "int", string, "" + tokenPattern.getId());
        javaVariable.addComment(new JavaComment(TOKEN_COMMENT));
        this.ifc.addVariable(javaVariable);
        this.constantNames.put(new Integer(tokenPattern.getId()), string);
    }

    public void addProduction(ProductionPattern productionPattern) {
        if (!productionPattern.isSynthetic()) {
            String string = this.gen.getCodeStyle().getUpperCase(productionPattern.getName());
            int n = 20;
            JavaVariable javaVariable = new JavaVariable(n, "int", string, "" + productionPattern.getId());
            javaVariable.addComment(new JavaComment(PRODUCTION_COMMENT));
            this.ifc.addVariable(javaVariable);
            this.constantNames.put(new Integer(productionPattern.getId()), string);
        }
    }

    public String getConstant(int n) {
        String string = (String)this.constantNames.get(new Integer(n));
        if (string == null) {
            return null;
        }
        return this.ifc.toString() + "." + string;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

