/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaMethod;
import net.percederberg.grammatica.output.JavaConstantsFile;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaAnalyzerFile {
    private static final String TYPE_COMMENT = "A class providing callback methods for the parser.";
    private static final String ENTER_COMMENT = "Called when entering a parse tree node.\n\n@param node           the node being entered\n\n@throws ParseException if the node analysis discovered errors";
    private static final String EXIT_COMMENT = "Called when exiting a parse tree node.\n\n@param node           the node being exited\n\n@return the node to add to the parse tree, or\n        null if no parse tree should be created\n\n@throws ParseException if the node analysis discovered errors";
    private static final String CHILD_COMMENT = "Called when adding a child to a parse tree node.\n\n@param node           the parent node\n@param child          the child node, or null\n\n@throws ParseException if the node analysis discovered errors";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaClass cls;
    private JavaMethod enter;
    private JavaMethod exit;
    private JavaMethod child;

    public JavaAnalyzerFile(JavaParserGenerator javaParserGenerator) {
        this.gen = javaParserGenerator;
        this.file = javaParserGenerator.createJavaFile();
        int n = javaParserGenerator.getPublicAccess() ? 8 : 10;
        this.cls = new JavaClass(n, javaParserGenerator.getBaseName() + "Analyzer", "Analyzer");
        this.enter = new JavaMethod(1, "enter", "Node node", "void");
        this.exit = new JavaMethod(1, "exit", "Node node", "Node");
        this.child = new JavaMethod(1, "child", "Production node, Node child", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addClass(this.cls);
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, string));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Analyzer"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Node"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "ParseException"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Production"));
        this.file.addImport(new JavaImport("net.percederberg.grammatica.parser", "Token"));
        string = TYPE_COMMENT;
        if (this.gen.getClassComment() != null) {
            string = string + "\n\n" + this.gen.getClassComment();
        }
        this.cls.addComment(new JavaComment(string));
        this.enter.addComment(new JavaComment(ENTER_COMMENT));
        this.enter.addThrows("ParseException");
        this.enter.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new JavaComment(EXIT_COMMENT));
        this.exit.addThrows("ParseException");
        this.exit.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.exit);
        this.child.addComment(new JavaComment(CHILD_COMMENT));
        this.child.addThrows("ParseException");
        this.child.addCode("switch (node.getId()) {");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern tokenPattern, JavaConstantsFile javaConstantsFile) {
        String string = javaConstantsFile.getConstant(tokenPattern.getId());
        if (!tokenPattern.isIgnore()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(tokenPattern.getName(), true);
            this.addEnterCase(string, string2, "Token");
            this.addEnterMethod(string2, "Token");
            this.addExitCase(string, string2, "Token");
            this.addExitMethod(string2, "Token");
        }
    }

    public void addProduction(ProductionPattern productionPattern, JavaConstantsFile javaConstantsFile) {
        String string = javaConstantsFile.getConstant(productionPattern.getId());
        if (!productionPattern.isSynthetic()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(productionPattern.getName(), true);
            this.addEnterCase(string, string2, "Production");
            this.addEnterMethod(string2, "Production");
            this.addExitCase(string, string2, "Production");
            this.addExitMethod(string2, "Production");
            this.addChildCase(string, string2);
            this.addChildMethod(string2);
        }
    }

    private void addEnterCase(String string, String string2, String string3) {
        this.enter.addCode("case " + string + ":");
        this.enter.addCode("    enter" + string2 + "((" + string3 + ") node);");
        this.enter.addCode("    break;");
    }

    private void addExitCase(String string, String string2, String string3) {
        this.exit.addCode("case " + string + ":");
        this.exit.addCode("    return exit" + string2 + "((" + string3 + ") node);");
    }

    private void addChildCase(String string, String string2) {
        this.child.addCode("case " + string + ":");
        this.child.addCode("    child" + string2 + "(node, child);");
        this.child.addCode("    break;");
    }

    private void addEnterMethod(String string, String string2) {
        JavaMethod javaMethod = new JavaMethod(1, "enter" + string, string2 + " node", "void");
        javaMethod.addComment(new JavaComment(ENTER_COMMENT));
        javaMethod.addThrows("ParseException");
        this.cls.addMethod(javaMethod);
    }

    private void addExitMethod(String string, String string2) {
        JavaMethod javaMethod = new JavaMethod(1, "exit" + string, string2 + " node", "Node");
        javaMethod.addComment(new JavaComment(EXIT_COMMENT));
        javaMethod.addThrows("ParseException");
        javaMethod.addCode("return node;");
        this.cls.addMethod(javaMethod);
    }

    private void addChildMethod(String string) {
        JavaMethod javaMethod = new JavaMethod(1, "child" + string, "Production node, Node child", "void");
        javaMethod.addComment(new JavaComment(CHILD_COMMENT));
        javaMethod.addThrows("ParseException");
        javaMethod.addCode("node.addChild(child);");
        this.cls.addMethod(javaMethod);
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.enter.addCode("}");
        this.exit.addCode("}");
        this.exit.addCode("return node;");
        this.child.addCode("}");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

