/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpConstructor;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

class CSharpTokenizerFile {
    private static final String TYPE_COMMENT = "<remarks>A character stream tokenizer.</remarks>";
    private static final String CONSTRUCTOR_COMMENT = "<summary>Creates a new tokenizer for the specified input\nstream.</summary>\n\n<param name='input'>the input stream to read</param>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the tokenizer by creating all the token\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpMethod initMethod;

    public CSharpTokenizerFile(CSharpParserGenerator cSharpParserGenerator) {
        String string = cSharpParserGenerator.getBaseName() + "Tokenizer";
        this.gen = cSharpParserGenerator;
        this.file = new CSharpFile(cSharpParserGenerator.getBaseDir(), string);
        int n = cSharpParserGenerator.getPublicAccess() ? 1 : 4;
        this.cls = new CSharpClass(n, string, "Tokenizer");
        this.initMethod = new CSharpMethod(5, "CreatePatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addUsing(new CSharpUsing("System.IO"));
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace cSharpNamespace = new CSharpNamespace(this.gen.getNamespace());
            cSharpNamespace.addClass(this.cls);
            this.file.addNamespace(cSharpNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, string));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        CSharpConstructor cSharpConstructor = new CSharpConstructor("TextReader input");
        this.cls.addConstructor(cSharpConstructor);
        cSharpConstructor.addComment(new CSharpComment(CONSTRUCTOR_COMMENT));
        cSharpConstructor.addInitializer("base(input, " + !this.gen.getGrammar().getCaseSensitive() + ")");
        cSharpConstructor.addCode("CreatePatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new CSharpComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("TokenPattern  pattern;");
    }

    public void addToken(TokenPattern tokenPattern, CSharpConstantsFile cSharpConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = new TokenPattern((int) ");
        stringBuffer.append(cSharpConstantsFile.getConstant(tokenPattern.getId()));
        stringBuffer.append(",\n");
        stringBuffer.append("                           \"");
        stringBuffer.append(tokenPattern.getName());
        stringBuffer.append("\",\n");
        stringBuffer.append("                           TokenPattern.PatternType.");
        switch (tokenPattern.getType()) {
            case 1: {
                stringBuffer.append("STRING");
                break;
            }
            case 2: {
                stringBuffer.append("REGEXP");
            }
        }
        stringBuffer.append(",\n");
        stringBuffer.append("                           ");
        String string = tokenPattern.getPattern();
        stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
        stringBuffer.append(");\n");
        if (tokenPattern.isError()) {
            if (tokenPattern.getErrorMessage() == null) {
                stringBuffer.append("pattern.Error = true");
            } else {
                stringBuffer.append("pattern.ErrorMessage = ");
                string = tokenPattern.getErrorMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
            }
            stringBuffer.append(";\n");
        }
        if (tokenPattern.isIgnore()) {
            if (tokenPattern.getIgnoreMessage() == null) {
                stringBuffer.append("pattern.Ignore = true");
            } else {
                stringBuffer.append("pattern.IgnoreMessage = ");
                string = tokenPattern.getIgnoreMessage();
                stringBuffer.append(this.gen.getCodeStyle().getStringConstant(string, '\\'));
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("AddPattern(pattern);");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

