/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.output.CSharpAnalyzerFile;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserFile;
import net.percederberg.grammatica.output.CSharpTokenizerFile;
import net.percederberg.grammatica.output.ParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

public class CSharpParserGenerator
extends ParserGenerator {
    private String baseName = null;
    private String namespace = null;
    private boolean publicAccess = false;

    public CSharpParserGenerator(Grammar grammar) {
        super(grammar);
        this.initialize();
    }

    private void initialize() {
        String string = this.getGrammar().getFileName();
        if (string.indexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        if (string.indexOf(92) >= 0) {
            string = string.substring(string.lastIndexOf(92) + 1);
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.indexOf(46));
        }
        if (Character.isLowerCase(string.charAt(0))) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        this.baseName = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public boolean getPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean bl) {
        this.publicAccess = bl;
    }

    public CodeStyle getCodeStyle() {
        return CodeStyle.CSHARP;
    }

    public void write() throws IOException {
        ProductionPattern productionPattern;
        int n;
        Grammar grammar = this.getGrammar();
        CSharpConstantsFile cSharpConstantsFile = new CSharpConstantsFile(this);
        CSharpTokenizerFile cSharpTokenizerFile = new CSharpTokenizerFile(this);
        CSharpAnalyzerFile cSharpAnalyzerFile = new CSharpAnalyzerFile(this);
        CSharpParserFile cSharpParserFile = new CSharpParserFile(this, cSharpTokenizerFile, cSharpAnalyzerFile);
        for (n = 0; n < grammar.getTokenPatternCount(); ++n) {
            TokenPattern tokenPattern = grammar.getTokenPattern(n);
            cSharpConstantsFile.addToken(tokenPattern);
            cSharpTokenizerFile.addToken(tokenPattern, cSharpConstantsFile);
            cSharpAnalyzerFile.addToken(tokenPattern, cSharpConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            cSharpConstantsFile.addProduction(productionPattern);
            cSharpParserFile.addProductionConstant(productionPattern);
            cSharpAnalyzerFile.addProduction(productionPattern, cSharpConstantsFile);
        }
        for (n = 0; n < grammar.getProductionPatternCount(); ++n) {
            productionPattern = grammar.getProductionPattern(n);
            cSharpParserFile.addProduction(productionPattern, cSharpConstantsFile);
        }
        cSharpConstantsFile.writeCode();
        cSharpTokenizerFile.writeCode();
        cSharpParserFile.writeCode();
        cSharpAnalyzerFile.writeCode();
    }
}

