/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpConstructor;
import net.percederberg.grammatica.code.csharp.CSharpEnumeration;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpAnalyzerFile;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.CSharpTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;

class CSharpParserFile {
    private static final String TYPE_COMMENT = "<remarks>A token stream parser.</remarks>";
    private static final String ENUM_COMMENT = "<summary>An enumeration with the generated production node\nidentity constants.</summary>";
    private static final String CONSTRUCTOR1_COMMENT = "<summary>Creates a new parser with a default analyzer.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String CONSTRUCTOR2_COMMENT = "<summary>Creates a new parser.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<param name='analyzer'>the analyzer to parse with</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String FACTORY_COMMENT = "<summary>Creates a new tokenizer for this parser. Can be overridden\nby a subclass to provide a custom implementation.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<returns>the tokenizer created</returns>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the parser by creating all the production\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpEnumeration enm;
    private CSharpMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public CSharpParserFile(CSharpParserGenerator cSharpParserGenerator, CSharpTokenizerFile cSharpTokenizerFile, CSharpAnalyzerFile cSharpAnalyzerFile) {
        String string = cSharpParserGenerator.getBaseName() + "Parser";
        this.gen = cSharpParserGenerator;
        this.file = new CSharpFile(cSharpParserGenerator.getBaseDir(), string);
        int n = cSharpParserGenerator.getPublicAccess() ? 1 : 4;
        this.cls = new CSharpClass(n, string, "RecursiveDescentParser");
        this.enm = new CSharpEnumeration(5, "SynteticPatterns");
        this.initMethod = new CSharpMethod(5, "CreatePatterns", "", "void");
        this.initializeCode(cSharpTokenizerFile, cSharpAnalyzerFile);
    }

    private void initializeCode(CSharpTokenizerFile cSharpTokenizerFile, CSharpAnalyzerFile cSharpAnalyzerFile) {
        this.file.addUsing(new CSharpUsing("System.IO"));
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace cSharpNamespace = new CSharpNamespace(this.gen.getNamespace());
            cSharpNamespace.addClass(this.cls);
            this.file.addNamespace(cSharpNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, string));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        this.cls.addEnumeration(this.enm);
        this.enm.addComment(new CSharpComment(ENUM_COMMENT));
        CSharpConstructor cSharpConstructor = new CSharpConstructor("TextReader input");
        this.cls.addConstructor(cSharpConstructor);
        cSharpConstructor.addComment(new CSharpComment(CONSTRUCTOR1_COMMENT));
        cSharpConstructor.addInitializer("base(input)");
        cSharpConstructor.addCode("CreatePatterns();");
        cSharpConstructor = new CSharpConstructor("TextReader input, " + cSharpAnalyzerFile.getClassName() + " analyzer");
        this.cls.addConstructor(cSharpConstructor);
        cSharpConstructor.addComment(new CSharpComment(CONSTRUCTOR2_COMMENT));
        cSharpConstructor.addInitializer("base(input, analyzer)");
        cSharpConstructor.addCode("CreatePatterns();");
        CSharpMethod cSharpMethod = new CSharpMethod(131, "NewTokenizer", "TextReader input", "Tokenizer");
        cSharpMethod.addComment(new CSharpComment(FACTORY_COMMENT));
        cSharpMethod.addCode("return new " + cSharpTokenizerFile.getClassName() + "(input);");
        this.cls.addMethod(cSharpMethod);
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new CSharpComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("ProductionPattern             pattern;");
        this.initMethod.addCode("ProductionPatternAlternative  alt;");
    }

    public void addProductionConstant(ProductionPattern productionPattern) {
        if (productionPattern.isSynthetic()) {
            String string = "SUBPRODUCTION_" + this.constantId;
            this.enm.addConstant(string, String.valueOf(this.constantId + 3000));
            this.constantNames.put(new Integer(productionPattern.getId()), string);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern productionPattern, CSharpConstantsFile cSharpConstantsFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pattern = new ProductionPattern((int) ");
        stringBuffer.append(this.getConstant(cSharpConstantsFile, productionPattern.getId()));
        stringBuffer.append(",\n");
        stringBuffer.append("                                \"");
        if (productionPattern.isSynthetic()) {
            String string = (String)this.constantNames.get(new Integer(productionPattern.getId()));
            stringBuffer.append(this.gen.getCodeStyle().getMixedCase(string, true));
        } else {
            stringBuffer.append(productionPattern.getName());
        }
        stringBuffer.append("\");");
        this.initMethod.addCode("");
        this.initMethod.addCode(stringBuffer.toString());
        if (productionPattern.isSynthetic()) {
            this.initMethod.addCode("pattern.Synthetic = true;");
        }
        for (int i = 0; i < productionPattern.getAlternativeCount(); ++i) {
            this.addProductionAlternative(productionPattern.getAlternative(i), cSharpConstantsFile);
        }
        this.initMethod.addCode("AddPattern(pattern);");
    }

    private void addProductionAlternative(ProductionPatternAlternative productionPatternAlternative, CSharpConstantsFile cSharpConstantsFile) {
        this.initMethod.addCode("alt = new ProductionPatternAlternative();");
        for (int i = 0; i < productionPatternAlternative.getElementCount(); ++i) {
            ProductionPatternElement productionPatternElement = productionPatternAlternative.getElement(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("alt.");
            if (productionPatternElement.isToken()) {
                stringBuffer.append("AddToken(");
            } else {
                stringBuffer.append("AddProduction(");
            }
            stringBuffer.append("(int) ");
            stringBuffer.append(this.getConstant(cSharpConstantsFile, productionPatternElement.getId()));
            stringBuffer.append(", ");
            stringBuffer.append(productionPatternElement.getMinCount());
            stringBuffer.append(", ");
            if (productionPatternElement.getMaxCount() == Integer.MAX_VALUE) {
                stringBuffer.append("-1");
            } else {
                stringBuffer.append(productionPatternElement.getMaxCount());
            }
            stringBuffer.append(");");
            this.initMethod.addCode(stringBuffer.toString());
        }
        this.initMethod.addCode("pattern.AddAlternative(alt);");
    }

    private String getConstant(CSharpConstantsFile cSharpConstantsFile, int n) {
        Integer n2 = new Integer(n);
        if (this.constantNames.containsKey(n2)) {
            return "SynteticPatterns." + this.constantNames.get(n2);
        }
        return cSharpConstantsFile.getConstant(n);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

