/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpEnumeration;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class CSharpConstantsFile {
    private static final String TYPE_COMMENT = "<remarks>An enumeration with token and production node\nconstants.</remarks>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpEnumeration enm;
    private HashMap constantNames = new HashMap();

    public CSharpConstantsFile(CSharpParserGenerator cSharpParserGenerator) {
        String string = cSharpParserGenerator.getBaseName() + "Constants";
        this.gen = cSharpParserGenerator;
        this.file = new CSharpFile(cSharpParserGenerator.getBaseDir(), string);
        int n = cSharpParserGenerator.getPublicAccess() ? 1 : 4;
        this.enm = new CSharpEnumeration(n, string);
        this.initializeCode();
    }

    private void initializeCode() {
        if (this.gen.getNamespace() == null) {
            this.file.addEnumeration(this.enm);
        } else {
            CSharpNamespace cSharpNamespace = new CSharpNamespace(this.gen.getNamespace());
            cSharpNamespace.addEnumeration(this.enm);
            this.file.addNamespace(cSharpNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, string));
        this.enm.addComment(new CSharpComment(TYPE_COMMENT));
    }

    public void addToken(TokenPattern tokenPattern) {
        String string = this.gen.getCodeStyle().getUpperCase(tokenPattern.getName());
        this.enm.addConstant(string, String.valueOf(tokenPattern.getId()));
        this.constantNames.put(new Integer(tokenPattern.getId()), string);
    }

    public void addProduction(ProductionPattern productionPattern) {
        if (!productionPattern.isSynthetic()) {
            String string = this.gen.getCodeStyle().getUpperCase(productionPattern.getName());
            this.enm.addConstant(string, String.valueOf(productionPattern.getId()));
            this.constantNames.put(new Integer(productionPattern.getId()), string);
        }
    }

    public String getConstant(int n) {
        String string = (String)this.constantNames.get(new Integer(n));
        if (string == null) {
            return null;
        }
        return this.enm.toString() + "." + string;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

