/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class CSharpAnalyzerFile {
    private static final String TYPE_COMMENT = "<remarks>A class providing callback methods for the\nparser.</remarks>";
    private static final String ENTER_COMMENT = "<summary>Called when entering a parse tree node.</summary>\n\n<param name='node'>the node being entered</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String EXIT_COMMENT = "<summary>Called when exiting a parse tree node.</summary>\n\n<param name='node'>the node being exited</param>\n\n<returns>the node to add to the parse tree, or\n         null if no parse tree should be created</returns>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String CHILD_COMMENT = "<summary>Called when adding a child to a parse tree\nnode.</summary>\n\n<param name='node'>the parent node</param>\n<param name='child'>the child node, or null</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpMethod enter;
    private CSharpMethod exit;
    private CSharpMethod child;

    public CSharpAnalyzerFile(CSharpParserGenerator cSharpParserGenerator) {
        String string = cSharpParserGenerator.getBaseName() + "Analyzer";
        this.gen = cSharpParserGenerator;
        this.file = new CSharpFile(cSharpParserGenerator.getBaseDir(), string);
        int n = cSharpParserGenerator.getPublicAccess() ? 257 : 260;
        this.cls = new CSharpClass(n, string, "Analyzer");
        n = 129;
        this.enter = new CSharpMethod(n, "Enter", "Node node", "void");
        this.exit = new CSharpMethod(n, "Exit", "Node node", "Node");
        this.child = new CSharpMethod(n, "Child", "Production node, Node child", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace cSharpNamespace = new CSharpNamespace(this.gen.getNamespace());
            cSharpNamespace.addClass(this.cls);
            this.file.addNamespace(cSharpNamespace);
        }
        String string = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, string));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        this.enter.addComment(new CSharpComment(ENTER_COMMENT));
        this.enter.addCode("switch (node.Id) {");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new CSharpComment(EXIT_COMMENT));
        this.exit.addCode("switch (node.Id) {");
        this.cls.addMethod(this.exit);
        this.child.addComment(new CSharpComment(CHILD_COMMENT));
        this.child.addCode("switch (node.Id) {");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern tokenPattern, CSharpConstantsFile cSharpConstantsFile) {
        String string = cSharpConstantsFile.getConstant(tokenPattern.getId());
        if (!tokenPattern.isIgnore()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(tokenPattern.getName(), true);
            this.addEnterCase(string, string2, "Token");
            this.addEnterMethod(string2, "Token");
            this.addExitCase(string, string2, "Token");
            this.addExitMethod(string2, "Token");
        }
    }

    public void addProduction(ProductionPattern productionPattern, CSharpConstantsFile cSharpConstantsFile) {
        String string = cSharpConstantsFile.getConstant(productionPattern.getId());
        if (!productionPattern.isSynthetic()) {
            String string2 = this.gen.getCodeStyle().getMixedCase(productionPattern.getName(), true);
            this.addEnterCase(string, string2, "Production");
            this.addEnterMethod(string2, "Production");
            this.addExitCase(string, string2, "Production");
            this.addExitMethod(string2, "Production");
            this.addChildCase(string, string2);
            this.addChildMethod(string2);
        }
    }

    private void addEnterCase(String string, String string2, String string3) {
        this.enter.addCode("case (int) " + string + ":");
        this.enter.addCode("    Enter" + string2 + "((" + string3 + ") node);");
        this.enter.addCode("    break;");
    }

    private void addExitCase(String string, String string2, String string3) {
        this.exit.addCode("case (int) " + string + ":");
        this.exit.addCode("    return Exit" + string2 + "((" + string3 + ") node);");
    }

    private void addChildCase(String string, String string2) {
        this.child.addCode("case (int) " + string + ":");
        this.child.addCode("    Child" + string2 + "(node, child);");
        this.child.addCode("    break;");
    }

    private void addEnterMethod(String string, String string2) {
        CSharpMethod cSharpMethod = new CSharpMethod(33, "Enter" + string, string2 + " node", "void");
        cSharpMethod.addComment(new CSharpComment(ENTER_COMMENT));
        this.cls.addMethod(cSharpMethod);
    }

    private void addExitMethod(String string, String string2) {
        CSharpMethod cSharpMethod = new CSharpMethod(33, "Exit" + string, string2 + " node", "Node");
        cSharpMethod.addComment(new CSharpComment(EXIT_COMMENT));
        cSharpMethod.addCode("return node;");
        this.cls.addMethod(cSharpMethod);
    }

    private void addChildMethod(String string) {
        CSharpMethod cSharpMethod = new CSharpMethod(33, "Child" + string, "Production node, Node child", "void");
        cSharpMethod.addComment(new CSharpComment(CHILD_COMMENT));
        cSharpMethod.addCode("node.AddChild(child);");
        this.cls.addMethod(cSharpMethod);
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.enter.addCode("}");
        this.exit.addCode("}");
        this.exit.addCode("return node;");
        this.child.addCode("}");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

