/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

abstract class VisualBasicModifier {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int MUST_INHERIT = 8;
    public static final int NOT_INHERITABLE = 16;
    public static final int SHARED = 32;
    public static final int SHADOWS = 64;
    public static final int OVERRIDABLE = 128;
    public static final int NOT_OVERRIDABLE = 256;
    public static final int OVERRIDES = 512;
    public static final int MUST_OVERRIDE = 1024;
    public static final int OVERLOADS = 2048;

    VisualBasicModifier() {
    }

    public static String createModifierDecl(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n % 8) {
            case 1: {
                stringBuffer.append("Public ");
                break;
            }
            case 2: {
                stringBuffer.append("Protected Friend ");
                break;
            }
            case 3: {
                stringBuffer.append("Protected ");
                break;
            }
            case 4: {
                stringBuffer.append("Friend ");
                break;
            }
            case 5: {
                stringBuffer.append("Private ");
            }
        }
        if ((n & 8) > 0) {
            stringBuffer.append("MustInherit ");
        }
        if ((n & 0x10) > 0) {
            stringBuffer.append("NotInheritable ");
        }
        if ((n & 0x20) > 0) {
            stringBuffer.append("Shared ");
        }
        if ((n & 0x40) > 0) {
            stringBuffer.append("Shadows ");
        }
        if ((n & 0x80) > 0) {
            stringBuffer.append("Overridable ");
        }
        if ((n & 0x100) > 0) {
            stringBuffer.append("NotOverridable ");
        }
        if ((n & 0x200) > 0) {
            stringBuffer.append("Overrides ");
        }
        if ((n & 0x400) > 0) {
            stringBuffer.append("MustOverride ");
        }
        if ((n & 0x800) > 0) {
            stringBuffer.append("Overloads ");
        }
        return stringBuffer.toString();
    }
}

