/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicModifier;

public class VisualBasicMethod
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int SHARED = 32;
    public static final int SHADOWS = 64;
    public static final int OVERRIDABLE = 128;
    public static final int NOT_OVERRIDABLE = 256;
    public static final int OVERRIDES = 512;
    public static final int MUST_OVERRIDE = 1024;
    public static final int OVERLOADS = 2048;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private LinkedList code;
    private VisualBasicComment comment;
    private boolean printCode;

    public VisualBasicMethod(String string) {
        this(string, "");
    }

    public VisualBasicMethod(String string, String string2) {
        this(string, string2, "");
    }

    public VisualBasicMethod(String string, String string2, String string3) {
        this(1, string, string2, string3);
    }

    public VisualBasicMethod(int n, String string, String string2, String string3) {
        this.modifiers = n;
        this.name = string;
        this.args = string2;
        this.returnType = string3;
        this.code = new LinkedList();
        this.comment = null;
        this.printCode = true;
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(VisualBasicComment visualBasicComment) {
        this.comment = visualBasicComment;
    }

    public int category() {
        return (this.modifiers & 0x20) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 0x400) == 0;
    }

    public void setPrintCode(boolean bl) {
        this.printCode = bl;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(VisualBasicModifier.createModifierDecl(this.modifiers));
        if (this.returnType.equals("")) {
            stringBuffer.append("Sub");
        } else {
            stringBuffer.append("Function");
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.args);
        if (this.returnType.equals("")) {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(") As ");
            stringBuffer.append(this.returnType);
        }
        if (this.canPrintCode()) {
            stringBuffer.append("\n");
            for (int i = 0; i < this.code.size(); ++i) {
                if (this.code.get(i).toString().length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append(this.code.get(i).toString());
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(string);
            if (this.returnType.equals("")) {
                stringBuffer.append("End Sub");
            } else {
                stringBuffer.append("End Function");
            }
        }
        printWriter.println(stringBuffer.toString());
    }
}

