/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicModifier;

public class VisualBasicConstructor
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int SHARED = 32;
    private int modifiers;
    private VisualBasicClass cls;
    private String args;
    private LinkedList code;
    private VisualBasicComment comment;

    public VisualBasicConstructor() {
        this("");
    }

    public VisualBasicConstructor(String string) {
        this(1, string);
    }

    public VisualBasicConstructor(int n, String string) {
        this.modifiers = n;
        this.cls = null;
        this.args = string;
        this.code = new LinkedList();
        this.comment = null;
    }

    public VisualBasicClass getVisualBasicClass() {
        return this.cls;
    }

    void setVisualBasicClass(VisualBasicClass visualBasicClass) {
        this.cls = visualBasicClass;
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(VisualBasicComment visualBasicComment) {
        this.comment = visualBasicComment;
    }

    public int category() {
        return 7;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(VisualBasicModifier.createModifierDecl(this.modifiers));
        stringBuffer.append("Sub New(");
        stringBuffer.append(this.args);
        stringBuffer.append(")");
        for (int i = 0; i < this.code.size(); ++i) {
            if (this.code.get(i).toString().length() > 0) {
                stringBuffer.append(string2);
                stringBuffer.append(this.code.get(i).toString());
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("End Sub");
        printWriter.println(stringBuffer.toString());
    }
}

