/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaVariable
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    public static final int STATIC = 4;
    public static final int FINAL = 16;
    public static final int TRANSIENT = 128;
    public static final int VOLATILE = 256;
    private int modifiers;
    private String type;
    private String name;
    private String initValue;
    private LinkedList initValueList;
    private JavaComment comment;

    public JavaVariable(String string, String string2) {
        this(0, string, string2);
    }

    public JavaVariable(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public JavaVariable(String string, String string2, String string3) {
        this(0, string, string2, string3);
    }

    public JavaVariable(int n, String string, String string2, String string3) {
        this.modifiers = n;
        this.type = string;
        this.name = string2;
        this.initValue = string3;
        this.initValueList = new LinkedList();
        this.comment = null;
    }

    public void addComment(JavaComment javaComment) {
        this.comment = javaComment;
    }

    public void addArrayInit(String string) {
        if (this.initValue != null) {
            this.initValueList.add(this.initValue);
            this.initValue = null;
        }
        this.initValueList.add(string);
    }

    public int category() {
        return (this.modifiers & 4) > 0 ? 4 : 5;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string;
        String string2 = codeStyle.getIndent(n);
        String string3 = JavaModifier.createModifierDecl(this.modifiers);
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        if ((string = this.getInitCode(codeStyle, n)) == null) {
            printWriter.println(string2 + string3 + this.type + " " + this.name + ";");
        } else {
            printWriter.println(string2 + string3 + this.type + " " + this.name + " = " + string + ";");
        }
    }

    private String getInitCode(CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        if (this.initValueList.size() == 0 && this.initValue == null) {
            return null;
        }
        if (this.initValue != null) {
            return this.initValue;
        }
        StringBuffer stringBuffer = new StringBuffer("{\n");
        for (int i = 0; i < this.initValueList.size(); ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(this.initValueList.get(i).toString());
            if (i + 1 < this.initValueList.size()) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

