/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

abstract class JavaType
extends CodeElementContainer {
    private int modifiers;
    private String name;
    private String extendType;
    private String[] implementTypes = null;
    private JavaComment comment = null;

    protected JavaType(int n, String string, String string2, String string3) {
        this.modifiers = n;
        this.name = string;
        this.extendType = string2;
        if (string3 == null || string3.equals("")) {
            this.implementTypes = new String[0];
        } else {
            this.implementTypes = new String[1];
            this.implementTypes[0] = string3;
        }
    }

    protected JavaType(int n, String string, String string2, String[] stringArray) {
        this.modifiers = n;
        this.name = string;
        this.extendType = string2;
        this.implementTypes = stringArray;
    }

    public String toString() {
        return this.name;
    }

    public void addComment(JavaComment javaComment) {
        this.comment = javaComment;
    }

    protected void print(PrintWriter printWriter, CodeStyle codeStyle, int n, String string) {
        String string2;
        String string3 = codeStyle.getIndent(n);
        String string4 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string3);
        stringBuffer.append(JavaModifier.createModifierDecl(this.modifiers));
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        if (this.extendType != null && !this.extendType.equals("")) {
            stringBuffer.append(" extends ");
            stringBuffer.append(this.extendType);
        }
        if ((string2 = this.createImplDecl()).length() > 0) {
            if (stringBuffer.length() + string2.length() > codeStyle.getMargin()) {
                stringBuffer.append("\n");
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(" {");
        printWriter.println(stringBuffer.toString());
        printWriter.println();
        this.printContents(printWriter, codeStyle, n + 1);
        printWriter.println(string3 + "}");
    }

    protected void printSeparator(PrintWriter printWriter, CodeStyle codeStyle, CodeElement codeElement, CodeElement codeElement2) {
        if (codeElement != null && codeElement2 != null) {
            printWriter.println();
        }
    }

    private String createImplDecl() {
        StringBuffer stringBuffer = new StringBuffer("implements ");
        if (this.implementTypes == null || this.implementTypes.length <= 0) {
            return "";
        }
        for (int i = 0; i < this.implementTypes.length; ++i) {
            stringBuffer.append(this.implementTypes[i]);
            if (i + 1 >= this.implementTypes.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

