/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaMethod
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    public static final int STATIC = 4;
    public static final int ABSTRACT = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int NATIVE = 64;
    public static final int STRICTFP = 512;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private LinkedList throwList;
    private LinkedList code;
    private JavaComment comment;
    private boolean printCode;

    public JavaMethod(String string) {
        this(string, "");
    }

    public JavaMethod(String string, String string2) {
        this(string, string2, "void");
    }

    public JavaMethod(String string, String string2, String string3) {
        this(0, string, string2, string3);
    }

    public JavaMethod(int n, String string, String string2, String string3) {
        this.modifiers = n;
        this.name = string;
        this.args = string2;
        this.returnType = string3;
        this.throwList = new LinkedList();
        this.code = new LinkedList();
        this.comment = null;
        this.printCode = true;
    }

    public void addThrows(String string) {
        this.throwList.add(string);
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(JavaComment javaComment) {
        this.comment = javaComment;
    }

    public int category() {
        return (this.modifiers & 4) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 8) == 0;
    }

    public void setPrintCode(boolean bl) {
        this.printCode = bl;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(JavaModifier.createModifierDecl(this.modifiers));
        stringBuffer.append(this.returnType);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.args);
        stringBuffer.append(")");
        String string3 = this.getThrowDecl();
        if (string3.length() > 0) {
            if (stringBuffer.length() + string3.length() < codeStyle.getMargin()) {
                stringBuffer.append(" ");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
                bl = true;
            }
            stringBuffer.append(string3);
        }
        if (this.canPrintCode()) {
            stringBuffer.append(" {\n");
            if (bl && this.code.size() > 0) {
                stringBuffer.append("\n");
            }
            for (int i = 0; i < this.code.size(); ++i) {
                if (this.code.get(i).toString().length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append(this.code.get(i).toString());
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(string);
            stringBuffer.append("}");
        } else {
            stringBuffer.append(";");
        }
        printWriter.println(stringBuffer.toString());
    }

    private String getThrowDecl() {
        StringBuffer stringBuffer = new StringBuffer("throws ");
        if (this.throwList.size() == 0) {
            return "";
        }
        Collections.sort(this.throwList);
        for (int i = 0; i < this.throwList.size(); ++i) {
            stringBuffer.append(this.throwList.get(i).toString());
            if (i >= this.throwList.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

