/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaImport;
import net.percederberg.grammatica.code.java.JavaInterface;
import net.percederberg.grammatica.code.java.JavaPackage;

public class JavaFile
extends CodeElementContainer {
    private File dir;
    private CodeElement first = null;

    public JavaFile(File file) {
        this.dir = file;
    }

    public JavaFile(File file, JavaPackage javaPackage) {
        this.dir = javaPackage.toFile(file);
        this.addElement(javaPackage);
    }

    public String toString() {
        if (this.first == null) {
            return "UnknownFileName.java";
        }
        return this.first.toString() + ".java";
    }

    public void addComment(JavaComment javaComment) {
        this.addElement(javaComment);
    }

    public void addImport(JavaImport javaImport) {
        this.addElement(javaImport);
    }

    public void addClass(JavaClass javaClass) {
        if (this.first == null) {
            this.first = javaClass;
        }
        this.addElement(javaClass);
    }

    public void addInterface(JavaInterface javaInterface) {
        if (this.first == null) {
            this.first = javaInterface;
        }
        this.addElement(javaInterface);
    }

    public int category() {
        return 0;
    }

    public void writeCode(CodeStyle codeStyle) throws IOException {
        File file = new File(this.dir, this.toString());
        this.createFile(file);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        this.print(printWriter, codeStyle, 0);
        printWriter.close();
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        this.printContents(printWriter, codeStyle, n);
    }
}

