/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaConstructor
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    private int modifiers;
    private JavaClass cls;
    private String args;
    private LinkedList throwList;
    private LinkedList code;
    private JavaComment comment;

    public JavaConstructor() {
        this("");
    }

    public JavaConstructor(String string) {
        this(0, string);
    }

    public JavaConstructor(int n, String string) {
        this.modifiers = n;
        this.cls = null;
        this.args = string;
        this.throwList = new LinkedList();
        this.code = new LinkedList();
        this.comment = null;
    }

    public JavaClass getJavaClass() {
        return this.cls;
    }

    void setJavaClass(JavaClass javaClass) {
        this.cls = javaClass;
    }

    public void addThrows(String string) {
        this.throwList.add(string);
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(JavaComment javaComment) {
        this.comment = javaComment;
    }

    public int category() {
        return 7;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(JavaModifier.createModifierDecl(this.modifiers));
        stringBuffer.append(this.cls.toString());
        stringBuffer.append("(");
        stringBuffer.append(this.args);
        stringBuffer.append(")");
        String string3 = this.getThrowDecl();
        if (string3.length() > 0) {
            if (stringBuffer.length() + string3.length() < codeStyle.getMargin()) {
                stringBuffer.append(" ");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
                bl = true;
            }
            stringBuffer.append(string3);
        }
        stringBuffer.append(" {\n");
        if (bl && this.code.size() > 0) {
            stringBuffer.append("\n");
        }
        for (int i = 0; i < this.code.size(); ++i) {
            if (this.code.get(i).toString().length() > 0) {
                stringBuffer.append(string2);
                stringBuffer.append(this.code.get(i).toString());
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        printWriter.println(stringBuffer.toString());
    }

    private String getThrowDecl() {
        StringBuffer stringBuffer = new StringBuffer("throws ");
        if (this.throwList.size() == 0) {
            return "";
        }
        Collections.sort(this.throwList);
        for (int i = 0; i < this.throwList.size(); ++i) {
            stringBuffer.append(this.throwList.get(i).toString());
            if (i >= this.throwList.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

