/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpModifier;

public class CSharpMethod
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int STATIC = 8;
    public static final int NEW = 16;
    public static final int VIRTUAL = 32;
    public static final int SEALED = 64;
    public static final int OVERRIDE = 128;
    public static final int ABSTRACT = 256;
    public static final int EXTERN = 512;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private LinkedList code;
    private CSharpComment comment;
    private boolean printCode;

    public CSharpMethod(String string) {
        this(string, "");
    }

    public CSharpMethod(String string, String string2) {
        this(string, string2, "void");
    }

    public CSharpMethod(String string, String string2, String string3) {
        this(1, string, string2, string3);
    }

    public CSharpMethod(int n, String string, String string2, String string3) {
        this.modifiers = n;
        this.name = string;
        this.args = string2;
        this.returnType = string3;
        this.code = new LinkedList();
        this.comment = null;
        this.printCode = true;
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(CSharpComment cSharpComment) {
        this.comment = cSharpComment;
    }

    public int category() {
        return (this.modifiers & 8) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 0x100) == 0;
    }

    public void setPrintCode(boolean bl) {
        this.printCode = bl;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(CSharpModifier.createModifierDecl(this.modifiers));
        stringBuffer.append(this.returnType);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.args);
        stringBuffer.append(")");
        if (this.canPrintCode()) {
            stringBuffer.append(" {\n");
            for (int i = 0; i < this.code.size(); ++i) {
                if (this.code.get(i).toString().length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append(this.code.get(i).toString());
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(string);
            stringBuffer.append("}");
        } else {
            stringBuffer.append(";");
        }
        printWriter.println(stringBuffer.toString());
    }
}

