/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpModifier;

public class CSharpConstructor
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int EXTERN = 512;
    private int modifiers;
    private CSharpClass cls;
    private String args;
    private String initializer;
    private LinkedList code;
    private CSharpComment comment;

    public CSharpConstructor() {
        this("");
    }

    public CSharpConstructor(String string) {
        this(1, string);
    }

    public CSharpConstructor(int n, String string) {
        this.modifiers = n;
        this.cls = null;
        this.args = string;
        this.initializer = null;
        this.code = new LinkedList();
        this.comment = null;
    }

    public CSharpClass getCSharpClass() {
        return this.cls;
    }

    void setCSharpClass(CSharpClass cSharpClass) {
        this.cls = cSharpClass;
    }

    public void addInitializer(String string) {
        this.initializer = string;
    }

    public void addCode(String string) {
        int n = string.indexOf(10);
        while (n >= 0) {
            this.code.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.code.add(string);
    }

    public void addComment(CSharpComment cSharpComment) {
        this.comment = cSharpComment;
    }

    public int category() {
        return 7;
    }

    public void print(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        String string = codeStyle.getIndent(n);
        String string2 = codeStyle.getIndent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(printWriter, codeStyle, n);
        }
        stringBuffer.append(string);
        stringBuffer.append(CSharpModifier.createModifierDecl(this.modifiers));
        stringBuffer.append(this.cls.toString());
        stringBuffer.append("(");
        stringBuffer.append(this.args);
        stringBuffer.append(")");
        if (this.initializer != null) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.initializer);
        }
        stringBuffer.append(" {\n");
        if (this.initializer != null && this.code.size() > 0) {
            stringBuffer.append("\n");
        }
        for (int i = 0; i < this.code.size(); ++i) {
            if (this.code.get(i).toString().length() > 0) {
                stringBuffer.append(string2);
                stringBuffer.append(this.code.get(i).toString());
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        printWriter.println(stringBuffer.toString());
    }
}

