/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;

public abstract class CodeElementContainer
extends CodeElement {
    private LinkedList contents = new LinkedList();

    protected void addElement(CodeElement codeElement) {
        if (!this.contents.contains(codeElement)) {
            this.contents.add(codeElement);
        }
    }

    protected void printContents(PrintWriter printWriter, CodeStyle codeStyle, int n) {
        CodeElement codeElement = null;
        Collections.sort(this.contents);
        for (int i = 0; i < this.contents.size(); ++i) {
            CodeElement codeElement2 = (CodeElement)this.contents.get(i);
            this.printSeparator(printWriter, codeStyle, codeElement, codeElement2);
            codeElement2.print(printWriter, codeStyle, n);
            codeElement = codeElement2;
        }
    }

    protected void printSeparator(PrintWriter printWriter, CodeStyle codeStyle, CodeElement codeElement, CodeElement codeElement2) {
        if (codeElement != null && codeElement2 != null && codeElement.category() != codeElement2.category()) {
            printWriter.println();
        }
    }

    protected void createFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new IOException("couldn't create " + file + ": " + iOException.getMessage());
            }
        }
    }
}

