/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.TreePrinter;
import net.percederberg.grammatica.ant.ProcessingElement;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class ValidationElement
implements ProcessingElement {
    private String type = null;
    private File file = null;
    private boolean quiet = false;

    public void setType(String string) {
        this.type = string;
    }

    public void setInputfile(File file) {
        this.file = file;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void validate() throws RuntimeException {
        if (this.type == null) {
            throw new RuntimeException("missing 'type' attribute in <validate>");
        }
        if (!(this.type.equals("debug") || this.type.equals("tokenize") || this.type.equals("parse") || this.type.equals("profile"))) {
            throw new RuntimeException("value of 'type' attribute in <validate> must be one of 'debug', 'tokenize', 'parse', or 'profile'");
        }
        if (this.file == null && !this.type.equals("debug")) {
            throw new RuntimeException("missing 'inputfile' attribute in <validate>");
        }
    }

    public void process(Grammar grammar) throws RuntimeException {
        if (this.type.equals("debug")) {
            this.debug(grammar);
        } else if (this.type.equals("tokenize")) {
            this.tokenize(grammar);
        } else if (this.type.equals("parse")) {
            this.parse(grammar);
        } else if (this.type.equals("profile")) {
            this.profile(grammar);
        } else {
            throw new RuntimeException("unknown <validation> type: " + this.type);
        }
    }

    private void debug(Grammar grammar) throws RuntimeException {
        Tokenizer tokenizer = null;
        Parser parser = null;
        try {
            tokenizer = grammar.createTokenizer(null);
            parser = grammar.createParser(tokenizer);
        }
        catch (GrammarException grammarException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + grammarException.getMessage());
        }
        if (!this.quiet) {
            System.out.println("Contents of " + grammar.getFileName() + ":");
            System.out.println();
            System.out.println("Token Declarations:");
            System.out.println("-------------------");
            System.out.print(tokenizer);
            System.out.println("Production Declarations:");
            System.out.println("------------------------");
            System.out.print(parser);
        }
    }

    private void tokenize(Grammar grammar) throws RuntimeException {
        try {
            Token token;
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(this.file));
            if (!this.quiet) {
                System.out.println("Tokens from " + this.file + ":");
            }
            while ((token = tokenizer.next()) != null) {
                if (this.quiet) continue;
                System.out.println(token);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        catch (GrammarException grammarException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + grammarException.getMessage());
        }
        catch (ParseException parseException) {
            throw new RuntimeException("in file " + this.file + ": " + parseException.getMessage());
        }
    }

    private void parse(Grammar grammar) throws RuntimeException {
        try {
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(this.file));
            TreePrinter treePrinter = this.quiet ? null : new TreePrinter(System.out);
            Parser parser = grammar.createParser(tokenizer, treePrinter);
            if (!this.quiet) {
                System.out.println("Parse tree from " + this.file + ":");
            }
            parser.parse();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        catch (GrammarException grammarException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + grammarException.getMessage());
        }
        catch (ParserCreationException parserCreationException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + parserCreationException.getMessage());
        }
        catch (ParserLogException parserLogException) {
            throw new RuntimeException("in file " + this.file + ": " + parserLogException.getMessage());
        }
    }

    private void profile(Grammar grammar) throws RuntimeException {
        int n;
        long l;
        Tokenizer tokenizer;
        try {
            tokenizer = grammar.createTokenizer(new FileReader(this.file));
            System.out.println("Tokenizing " + this.file);
            l = System.currentTimeMillis();
            n = 0;
            while (tokenizer.next() != null) {
                ++n;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("  Time elapsed:  " + l + " millisec");
            System.out.println("  Tokens found:  " + n);
            System.out.println("  Average speed: " + (long)n / l + " tokens/millisec");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        catch (GrammarException grammarException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + grammarException.getMessage());
        }
        catch (ParseException parseException) {
            throw new RuntimeException("in file " + this.file + ": " + parseException.getMessage());
        }
        try {
            tokenizer = grammar.createTokenizer(new FileReader(this.file));
            Parser parser = grammar.createParser(tokenizer);
            System.out.println("Parsing " + this.file);
            l = System.currentTimeMillis();
            Node node = parser.parse();
            l = System.currentTimeMillis() - l;
            n = 1 + node.getDescendantCount();
            System.out.println("  Time elapsed:  " + l + " millisec");
            System.out.println("  Nodes found:   " + n);
            System.out.println("  Average speed: " + (long)n / l + " nodes/millisec");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        catch (GrammarException grammarException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + grammarException.getMessage());
        }
        catch (ParserCreationException parserCreationException) {
            throw new RuntimeException("in grammar " + grammar.getFileName() + ": " + parserCreationException.getMessage());
        }
        catch (ParserLogException parserLogException) {
            throw new RuntimeException("in file " + this.file + ": " + parserLogException.getMessage());
        }
    }
}

