/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.ant.CSharpElement;
import net.percederberg.grammatica.ant.JavaElement;
import net.percederberg.grammatica.ant.ProcessingElement;
import net.percederberg.grammatica.ant.ValidationElement;
import net.percederberg.grammatica.ant.VisualBasicElement;
import net.percederberg.grammatica.parser.ParserLogException;

public class GrammaticaTask {
    private File file = null;
    private boolean failOnError = true;
    private Vector processors = new Vector();

    public void setGrammar(File file) {
        this.file = file;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void addValidation(ValidationElement validationElement) {
        this.processors.add(validationElement);
    }

    public void addCSharp(CSharpElement cSharpElement) {
        this.processors.add(cSharpElement);
    }

    public void addJava(JavaElement javaElement) {
        this.processors.add(javaElement);
    }

    public void addVisualBasic(VisualBasicElement visualBasicElement) {
        this.processors.add(visualBasicElement);
    }

    public void execute() throws RuntimeException {
        Grammar grammar;
        int n;
        if (this.file == null) {
            throw new RuntimeException("missing 'grammar' attribute");
        }
        if (this.processors.size() <= 0) {
            throw new RuntimeException("missing <validate>, <java>, <csharp> or <visualbasic> inner element");
        }
        for (n = 0; n < this.processors.size(); ++n) {
            ((ProcessingElement)this.processors.get(n)).validate();
        }
        try {
            grammar = new Grammar(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        catch (ParserLogException parserLogException) {
            this.handleError(parserLogException);
            return;
        }
        catch (GrammarException grammarException) {
            this.handleError(grammarException);
            return;
        }
        for (n = 0; n < this.processors.size(); ++n) {
            try {
                ((ProcessingElement)this.processors.get(n)).process(grammar);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.handleError(runtimeException);
            }
        }
    }

    private void handleError(Exception exception) throws RuntimeException {
        if (this.failOnError) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        System.err.println("ERROR: " + exception.getMessage());
    }
}

