/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarAnalyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;

class SecondPassAnalyzer
extends GrammarAnalyzer {
    private Grammar grammar;
    private ProductionPattern currentProduction = null;
    private int nextSynteticId = 3001;

    public SecondPassAnalyzer(Grammar grammar) {
        this.grammar = grammar;
    }

    protected Node exitIdentifier(Token token) throws ParseException {
        String string = token.getImage();
        TokenPattern tokenPattern = this.grammar.getTokenPatternByName(string);
        ProductionPattern productionPattern = this.grammar.getProductionPatternByName(string);
        if (tokenPattern != null) {
            token.addValue(tokenPattern);
        } else if (productionPattern != null) {
            token.addValue(productionPattern);
        } else {
            throw new ParseException(6, "unrecognized identifier '" + string + "'", token.getStartLine(), token.getStartColumn());
        }
        return token;
    }

    protected Node exitQuotedString(Token token) throws ParseException {
        String string = token.getImage();
        TokenPattern tokenPattern = this.grammar.getTokenPatternByImage(string = string.substring(1, string.length() - 1));
        if (tokenPattern == null) {
            throw new ParseException(6, "unrecognized token \"" + string + "\"", token.getStartLine(), token.getStartColumn());
        }
        token.addValue(tokenPattern);
        return token;
    }

    protected Node exitGrammar(Production production) {
        return null;
    }

    protected Node exitProductionPart(Production production) {
        return null;
    }

    protected void childProductionDeclaration(Production production, Node node) throws ParseException {
        super.childProductionDeclaration(production, node);
        if (node.getId() == 1019) {
            this.currentProduction = (ProductionPattern)node.getValue(0);
        }
    }

    protected Node exitProductionDeclaration(Production production) throws ParseException {
        ProductionPattern productionPattern = (ProductionPattern)this.getValue(this.getChildAt(production, 0), 0);
        Node node = this.getChildAt(production, 2);
        for (int i = 0; i < node.getValueCount(); ++i) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.getValue(node, i);
            try {
                productionPattern.addAlternative(productionPatternAlternative);
                continue;
            }
            catch (ParserCreationException parserCreationException) {
                throw new ParseException(6, parserCreationException.getMessage(), production.getStartLine(), production.getStartColumn());
            }
        }
        return null;
    }

    protected Node exitProduction(Production production) throws ParseException {
        ProductionPatternAlternative productionPatternAlternative = new ProductionPatternAlternative();
        production.addValue(productionPatternAlternative);
        for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = this.getChildAt(production, i);
            if (node.getId() == 2011) {
                for (int j = 0; j < node.getValueCount(); ++j) {
                    ProductionPatternElement productionPatternElement = (ProductionPatternElement)this.getValue(node, j);
                    productionPatternAlternative.addElement(productionPatternElement);
                }
                continue;
            }
            if (node.getId() != 2010) continue;
            production.addValues(node.getAllValues());
        }
        return production;
    }

    protected Node exitProductionAtom(Production production) throws ParseException {
        boolean bl = false;
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        Node node = this.getChildAt(production, 0);
        switch (node.getId()) {
            case 1019: {
                Object object = this.getValue(node, 0);
                if (object instanceof TokenPattern) {
                    bl = true;
                    n = ((TokenPattern)object).getId();
                    break;
                }
                bl = false;
                n = ((ProductionPattern)object).getId();
                break;
            }
            case 1020: {
                bl = true;
                n = ((TokenPattern)this.getValue(node, 0)).getId();
                break;
            }
            case 1008: 
            case 1010: 
            case 1012: {
                if (node.getId() == 1010) {
                    n2 = 0;
                    n3 = -1;
                } else if (node.getId() == 1012) {
                    n2 = 0;
                    n3 = 1;
                }
                ProductionPatternElement productionPatternElement = this.getProductionElement(this.getChildAt(production, 1));
                bl = productionPatternElement.isToken();
                n = productionPatternElement.getId();
            }
        }
        node = this.getChildAt(production, production.getChildCount() - 1);
        if (node.getId() == 1014) {
            n2 = 0;
            n3 = 1;
        } else if (node.getId() == 1016) {
            n2 = 0;
            n3 = -1;
        } else if (node.getId() == 1015) {
            n2 = 1;
            n3 = -1;
        }
        production.addValue(new ProductionPatternElement(bl, n, n2, n3));
        return production;
    }

    private ProductionPatternElement getProductionElement(Node node) throws ParseException {
        ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.getValue(node, 0);
        if (node.getValueCount() == 1 && this.isSimple(productionPatternAlternative)) {
            return productionPatternAlternative.getElement(0);
        }
        String string = this.currentProduction.getName() + "(" + (this.nextSynteticId - 3000) + ")";
        ProductionPattern productionPattern = new ProductionPattern(this.nextSynteticId, string);
        productionPattern.setSynthetic(true);
        for (int i = 0; i < node.getValueCount(); ++i) {
            productionPatternAlternative = (ProductionPatternAlternative)this.getValue(node, i);
            try {
                productionPattern.addAlternative(productionPatternAlternative);
                continue;
            }
            catch (ParserCreationException parserCreationException) {
                throw new ParseException(6, parserCreationException.getMessage(), node.getStartLine(), node.getStartColumn());
            }
        }
        this.grammar.addProduction(productionPattern, node.getStartLine(), node.getEndLine());
        return new ProductionPatternElement(false, this.nextSynteticId++, 1, 1);
    }

    private boolean isSimple(ProductionPatternAlternative productionPatternAlternative) {
        return productionPatternAlternative.getElementCount() == 1 && productionPatternAlternative.getMinElementCount() == 1 && productionPatternAlternative.getMaxElementCount() == 1;
    }
}

