/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.TreePrinter;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammatica {
    private static final String COMMAND_HELP = "Generates source code for a C#, Java or Visual Basic parser from\na grammar file. This program comes with ABSOLUTELY NO WARRANTY;\nfor details see the LICENSE.txt file.\n\nSyntax: Grammatica <grammarfile> <action> [<options>]\n\nActions:\n  --debug\n      Debugs the grammar by validating it and printing the\n      internal representation.\n  --tokenize <file>\n      Debugs the grammar by using it to tokenize the specified\n      file. No code has to be generated for this.\n  --parse <file>\n      Debugs the grammar by using it to parse the specified\n      file. No code has to be generated for this.\n  --profile <file(s)>\n      Profiles the grammar by using it to parse the specified\n      file(s) and printing a statistic summary.\n  --csoutput <dir>\n      Creates a C# parser for the grammar (in source code).\n      The specified directory will be used as output directory\n      for the source code files.\n  --javaoutput <dir>\n      Creates a Java parser for the grammar (in source code).\n      The specified directory will be used as the base output\n      directory for the source code files.\n  --vboutput <dir>\n      Creates a Visual Basic (.NET) parser for the grammar (in\n      source code). The specified directory will be used as\n      output directory for the source code files.\n\nC# Output Options:\n  --csnamespace <package>\n      Sets the C# namespace to use in generated source code\n      files. By default no namespace declaration is included.\n  --csclassname <name>\n      Sets the C# class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --cspublic\n      Sets public access for all C# types generated. By default\n      type access is internal.\n\nJava Output Options:\n  --javapackage <package>\n      Sets the Java package to use in generated source code\n      files. By default no package declaration is included.\n  --javaclassname <name>\n      Sets the Java class name prefix to use in generated source\n      code files. By default the grammar file name is used.\n  --javapublic\n      Sets public access for all Java types. By default type\n      access is package local.\n\nVisual Basic Output Options:\n  --vbnamespace <package>\n      Sets the namespace to use in generated source code files.\n      By default no namespace declaration is included.\n  --vbclassname <name>\n      Sets the class name prefix to use in generated source code\n      files. By default the grammar file name is used.\n  --vbpublic\n      Sets public access for all types generated. By default type\n      access is friend.";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error in Grammatica has been found.\n    Please report this error to the maintainers (see the web\n    site for instructions). Be sure to include the Grammatica\n    version number, as well as the information below:\n";

    public static void main(String[] stringArray) {
        Grammar grammar = null;
        if (stringArray.length == 1 && stringArray[0].equals("--help")) {
            Grammatica.printHelp(null);
            System.exit(1);
        }
        if (stringArray.length < 2) {
            Grammatica.printHelp("Missing grammar file and/or action");
            System.exit(1);
        }
        try {
            grammar = new Grammar(new File(stringArray[0]));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Grammatica.printError(stringArray[0], fileNotFoundException);
            System.exit(1);
        }
        catch (ParserLogException parserLogException) {
            Grammatica.printError(stringArray[0], parserLogException);
            System.exit(1);
        }
        catch (GrammarException grammarException) {
            Grammatica.printError(grammarException);
            System.exit(1);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RuntimeException runtimeException) {
            Grammatica.printInternalError(runtimeException);
            System.exit(2);
        }
        try {
            if (stringArray[1].equals("--debug")) {
                Grammatica.debug(grammar);
            } else if (stringArray.length < 3) {
                Grammatica.printHelp("missing action file parameter");
                System.exit(1);
            } else if (stringArray[1].equals("--tokenize")) {
                Grammatica.tokenize(grammar, new File(stringArray[2]));
            } else if (stringArray[1].equals("--parse")) {
                Grammatica.parse(grammar, new File(stringArray[2]));
            } else if (stringArray[1].equals("--profile")) {
                Grammatica.profile(grammar, stringArray, 2);
            } else if (stringArray[1].equals("--javaoutput")) {
                Grammatica.writeJavaCode(stringArray, grammar);
            } else if (stringArray[1].equals("--csoutput")) {
                Grammatica.writeCSharpCode(stringArray, grammar);
            } else if (stringArray[1].equals("--vboutput")) {
                Grammatica.writeVisualBasicCode(stringArray, grammar);
            } else {
                Grammatica.printHelp("unrecognized option: " + stringArray[1]);
                System.exit(1);
            }
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RuntimeException runtimeException) {
            Grammatica.printInternalError(runtimeException);
            System.exit(2);
        }
    }

    private static void printHelp(String string) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (string != null) {
            System.err.print("Error: ");
            System.err.println(string);
            System.err.println();
        }
    }

    private static void printError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: ");
        stringBuffer.append(exception.getMessage());
        System.err.println(stringBuffer.toString());
    }

    private static void printError(String string, FileNotFoundException fileNotFoundException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: couldn't open file:");
        stringBuffer.append("\n    ");
        stringBuffer.append(string);
        System.err.println(stringBuffer.toString());
    }

    private static void printError(String string, ParseException parseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: in ");
        stringBuffer.append(string);
        if (parseException.getLine() > 0) {
            stringBuffer.append(": line ");
            stringBuffer.append(parseException.getLine());
        }
        stringBuffer.append(":\n");
        stringBuffer.append(Grammatica.linebreakString(parseException.getErrorMessage(), "    ", 70));
        String string2 = Grammatica.readLines(string, parseException.getLine(), parseException.getLine());
        if (string2 != null) {
            stringBuffer.append("\n\n");
            stringBuffer.append(string2);
            for (int i = 1; i < parseException.getColumn(); ++i) {
                if (string2.charAt(i - 1) == '\t') {
                    stringBuffer.append("\t");
                    continue;
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("^");
        }
        System.err.println(stringBuffer.toString());
    }

    private static void printError(String string, ParserLogException parserLogException) {
        for (int i = 0; i < parserLogException.getErrorCount(); ++i) {
            Grammatica.printError(string, parserLogException.getError(i));
        }
    }

    private static void printError(GrammarException grammarException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error: in ");
        stringBuffer.append(grammarException.getFile());
        if (grammarException.getStartLine() > 0) {
            if (grammarException.getStartLine() == grammarException.getEndLine()) {
                stringBuffer.append(": line ");
                stringBuffer.append(grammarException.getStartLine());
            } else {
                stringBuffer.append(": lines ");
                stringBuffer.append(grammarException.getStartLine());
                stringBuffer.append("-");
                stringBuffer.append(grammarException.getEndLine());
            }
        }
        stringBuffer.append(":\n");
        stringBuffer.append(Grammatica.linebreakString(grammarException.getErrorMessage(), "    ", 70));
        String string = Grammatica.readLines(grammarException.getFile(), grammarException.getStartLine(), grammarException.getEndLine());
        if (string != null) {
            stringBuffer.append("\n\n");
            stringBuffer.append(string);
        }
        System.err.println(stringBuffer.toString());
    }

    private static void printInternalError(Exception exception) {
        System.err.println(INTERNAL_ERROR);
        exception.printStackTrace();
    }

    private static String linebreakString(String string, String string2, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() + string2.length() > n && ((n2 = string.lastIndexOf(32, n - string2.length())) >= 0 || (n2 = string.indexOf(32)) >= 0)) {
            stringBuffer.append(string2);
            stringBuffer.append(string.substring(0, n2));
            string = string.substring(n2 + 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String readLines(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 1 || n2 < n) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            for (int i = 0; i < n2; ++i) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bufferedReader.close();
                    return null;
                }
                if (n > i + 1) continue;
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static void debug(Grammar grammar) {
        Tokenizer tokenizer = null;
        Parser parser = null;
        try {
            tokenizer = grammar.createTokenizer(null);
            parser = grammar.createParser(tokenizer);
        }
        catch (GrammarException grammarException) {
            Grammatica.printInternalError(grammarException);
            System.exit(2);
        }
        System.out.println("Contents of " + grammar.getFileName() + ":");
        System.out.println();
        System.out.println("Token Declarations:");
        System.out.println("-------------------");
        System.out.print(tokenizer);
        System.out.println("Production Declarations:");
        System.out.println("------------------------");
        System.out.print(parser);
    }

    private static void tokenize(Grammar grammar, File file) {
        try {
            Token token;
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            System.out.println("Tokens from " + file + ":");
            while ((token = tokenizer.next()) != null) {
                System.out.println(token);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Grammatica.printError(file.toString(), fileNotFoundException);
            System.exit(1);
        }
        catch (GrammarException grammarException) {
            Grammatica.printInternalError(grammarException);
            System.exit(2);
        }
        catch (ParseException parseException) {
            Grammatica.printError(file.toString(), parseException);
            System.exit(1);
        }
    }

    private static void parse(Grammar grammar, File file) {
        try {
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            TreePrinter treePrinter = new TreePrinter(System.out);
            Parser parser = grammar.createParser(tokenizer, treePrinter);
            System.out.println("Parse tree from " + file + ":");
            parser.parse();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Grammatica.printError(file.toString(), fileNotFoundException);
            System.exit(1);
        }
        catch (GrammarException grammarException) {
            Grammatica.printInternalError(grammarException);
            System.exit(2);
        }
        catch (ParserCreationException parserCreationException) {
            Grammatica.printInternalError(parserCreationException);
            System.exit(2);
        }
        catch (ParserLogException parserLogException) {
            Grammatica.printError(file.toString(), parserLogException);
            System.exit(1);
        }
    }

    private static void profile(Grammar grammar, String[] stringArray, int n) {
        int n2;
        int n3;
        long l;
        Tokenizer tokenizer;
        File file = new File(stringArray[n]);
        int n4 = stringArray.length - n;
        try {
            System.out.println("Tokenizing " + n4 + " file(s)...");
            tokenizer = grammar.createTokenizer(new FileReader(file));
            l = System.currentTimeMillis();
            n3 = 0;
            for (n2 = n; n2 < stringArray.length; ++n2) {
                if (n2 > n) {
                    file = new File(stringArray[n2]);
                    tokenizer.reset(new FileReader(file));
                }
                while (tokenizer.next() != null) {
                    ++n3;
                }
            }
            l = System.currentTimeMillis() - l + 1L;
            System.out.println("  Time elapsed:  " + l + " millisec");
            System.out.println("  Tokens found:  " + n3);
            System.out.println("  Average speed: " + (long)n3 / l + " tokens/millisec");
            System.out.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Grammatica.printError(file.toString(), fileNotFoundException);
            System.exit(1);
        }
        catch (GrammarException grammarException) {
            Grammatica.printInternalError(grammarException);
            System.exit(2);
        }
        catch (ParseException parseException) {
            Grammatica.printError(file.toString(), parseException);
            System.exit(1);
        }
        try {
            System.out.println("Parsing " + n4 + " file(s)...");
            file = new File(stringArray[n]);
            tokenizer = grammar.createTokenizer(new FileReader(file));
            Parser parser = grammar.createParser(tokenizer);
            l = System.currentTimeMillis();
            n3 = 0;
            for (n2 = n; n2 < stringArray.length; ++n2) {
                if (n2 > n) {
                    file = new File(stringArray[n2]);
                    parser.reset(new FileReader(file));
                }
                Node node = parser.parse();
                n3 += 1 + node.getDescendantCount();
            }
            l = System.currentTimeMillis() - l + 1L;
            System.out.println("  Time elapsed:  " + l + " millisec");
            System.out.println("  Nodes found:   " + n3);
            System.out.println("  Average speed: " + (long)n3 / l + " nodes/millisec");
            System.out.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Grammatica.printError(file.toString(), fileNotFoundException);
            System.exit(1);
        }
        catch (GrammarException grammarException) {
            Grammatica.printInternalError(grammarException);
            System.exit(2);
        }
        catch (ParserCreationException parserCreationException) {
            Grammatica.printInternalError(parserCreationException);
            System.exit(2);
        }
        catch (ParserLogException parserLogException) {
            Grammatica.printError(file.toString(), parserLogException);
            System.exit(1);
        }
    }

    private static void writeJavaCode(String[] stringArray, Grammar grammar) {
        JavaParserGenerator javaParserGenerator = new JavaParserGenerator(grammar);
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--javaoutput")) {
                javaParserGenerator.setBaseDir(new File(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("--javapackage")) {
                javaParserGenerator.setBasePackage(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--javaclassname")) {
                javaParserGenerator.setBaseName(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--javapublic")) {
                javaParserGenerator.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + stringArray[i]);
            System.exit(1);
        }
        try {
            System.out.println("Writing Java parser source code...");
            javaParserGenerator.write();
            System.out.println("Done.");
        }
        catch (IOException iOException) {
            Grammatica.printError(iOException);
            System.exit(1);
        }
    }

    private static void writeCSharpCode(String[] stringArray, Grammar grammar) {
        CSharpParserGenerator cSharpParserGenerator = new CSharpParserGenerator(grammar);
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--csoutput")) {
                cSharpParserGenerator.setBaseDir(new File(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("--csnamespace")) {
                cSharpParserGenerator.setNamespace(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--csclassname")) {
                cSharpParserGenerator.setBaseName(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--cspublic")) {
                cSharpParserGenerator.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + stringArray[i]);
            System.exit(1);
        }
        try {
            System.out.println("Writing C# parser source code...");
            cSharpParserGenerator.write();
            System.out.println("Done.");
        }
        catch (IOException iOException) {
            Grammatica.printError(iOException);
            System.exit(1);
        }
    }

    private static void writeVisualBasicCode(String[] stringArray, Grammar grammar) {
        VisualBasicParserGenerator visualBasicParserGenerator = new VisualBasicParserGenerator(grammar);
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--vboutput")) {
                visualBasicParserGenerator.setBaseDir(new File(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("--vbnamespace")) {
                visualBasicParserGenerator.setNamespace(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--vbclassname")) {
                visualBasicParserGenerator.setBaseName(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--vbpublic")) {
                visualBasicParserGenerator.setPublicAccess(true);
                continue;
            }
            Grammatica.printHelp("unrecognized option: " + stringArray[i]);
            System.exit(1);
        }
        try {
            System.out.println("Writing Visual Basic parser source code...");
            visualBasicParserGenerator.write();
            System.out.println("Done.");
        }
        catch (IOException iOException) {
            Grammatica.printError(iOException);
            System.exit(1);
        }
    }
}

