/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import net.percederberg.grammatica.FirstPassAnalyzer;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.GrammarParser;
import net.percederberg.grammatica.SecondPassAnalyzer;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.RecursiveDescentParser;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammar {
    public static final String AUTHOR_DECLARATION = "AUTHOR";
    public static final String CASE_SENSITIVE_DECLARATION = "CASESENSITIVE";
    public static final String COPYRIGHT_DECLARATION = "COPYRIGHT";
    public static final String DATE_DECLARATION = "DATE";
    public static final String DESCRIPTION_DECLARATION = "DESCRIPTION";
    public static final String GRAMMAR_TYPE_DECLARATION = "GRAMMARTYPE";
    public static final String LICENSE_DECLARATION = "LICENSE";
    public static final String VERSION_DECLARATION = "VERSION";
    private String fileName = "";
    private HashMap declarations = new HashMap();
    private LinkedList tokens = new LinkedList();
    private HashMap tokenIds = new HashMap();
    private HashMap tokenNames = new HashMap();
    private HashMap tokenPatterns = new HashMap();
    private LinkedList productions = new LinkedList();
    private HashMap productionIds = new HashMap();
    private HashMap productionNames = new HashMap();
    private HashMap lines = new HashMap();

    public Grammar(File file) throws FileNotFoundException, ParserLogException, GrammarException {
        FirstPassAnalyzer firstPassAnalyzer = new FirstPassAnalyzer(this);
        SecondPassAnalyzer secondPassAnalyzer = new SecondPassAnalyzer(this);
        this.fileName = file.toString();
        try {
            GrammarParser grammarParser = new GrammarParser((Reader)new FileReader(file), firstPassAnalyzer);
            secondPassAnalyzer.analyze(grammarParser.parse());
        }
        catch (ParserCreationException parserCreationException) {
            throw new UnsupportedOperationException("internal error in grammar parser: " + parserCreationException.getMessage());
        }
        this.verify();
    }

    private void verify() throws GrammarException {
        String string = (String)this.declarations.get(GRAMMAR_TYPE_DECLARATION);
        if (string == null) {
            throw new GrammarException(this.fileName, "grammar header missing GRAMMARTYPE declaration");
        }
        if (!string.equals("LL")) {
            throw new GrammarException(this.fileName, "unrecognized GRAMMARTYPE value: '" + string + "', currently only 'LL' is supported");
        }
        if (this.productions.size() > 0) {
            this.createParser(this.createTokenizer(null));
        }
    }

    public Tokenizer createTokenizer(Reader reader) throws GrammarException {
        Tokenizer tokenizer;
        try {
            tokenizer = new Tokenizer(reader, !this.getCaseSensitive());
            for (int i = 0; i < this.tokens.size(); ++i) {
                tokenizer.addPattern((TokenPattern)this.tokens.get(i));
            }
        }
        catch (ParserCreationException parserCreationException) {
            if (parserCreationException.getName() == null) {
                throw new GrammarException(this.fileName, parserCreationException.getMessage());
            }
            LineRange lineRange = (LineRange)this.lines.get(parserCreationException.getName());
            throw new GrammarException(this.fileName, parserCreationException.getMessage(), lineRange.getStart(), lineRange.getEnd());
        }
        return tokenizer;
    }

    public Parser createParser(Tokenizer tokenizer) throws GrammarException {
        return this.createParser(tokenizer, null);
    }

    public Parser createParser(Tokenizer tokenizer, Analyzer analyzer) throws GrammarException {
        RecursiveDescentParser recursiveDescentParser;
        try {
            recursiveDescentParser = new RecursiveDescentParser(tokenizer, analyzer);
            for (int i = 0; i < this.productions.size(); ++i) {
                ((Parser)recursiveDescentParser).addPattern((ProductionPattern)this.productions.get(i));
            }
            ((Parser)recursiveDescentParser).prepare();
        }
        catch (ParserCreationException parserCreationException) {
            LineRange lineRange = (LineRange)this.lines.get(parserCreationException.getName());
            if (lineRange == null) {
                throw new GrammarException(this.fileName, parserCreationException.getMessage());
            }
            throw new GrammarException(this.fileName, parserCreationException.getMessage(), lineRange.getStart(), lineRange.getEnd());
        }
        return recursiveDescentParser;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDeclaration(String string) {
        return (String)this.declarations.get(string);
    }

    public boolean getCaseSensitive() {
        String string = this.getDeclaration(CASE_SENSITIVE_DECLARATION);
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("no") && !string.equalsIgnoreCase("false");
    }

    public int getTokenPatternCount() {
        return this.tokens.size();
    }

    public TokenPattern getTokenPattern(int n) {
        return (TokenPattern)this.tokens.get(n);
    }

    public TokenPattern getTokenPatternById(int n) {
        return (TokenPattern)this.tokenIds.get(new Integer(n));
    }

    public TokenPattern getTokenPatternByName(String string) {
        return (TokenPattern)this.tokenNames.get(string);
    }

    TokenPattern getTokenPatternByImage(String string) {
        return (TokenPattern)this.tokenPatterns.get(string);
    }

    public int getProductionPatternCount() {
        return this.productions.size();
    }

    public ProductionPattern getProductionPattern(int n) {
        return (ProductionPattern)this.productions.get(n);
    }

    public ProductionPattern getProductionPatternById(int n) {
        return (ProductionPattern)this.productionIds.get(new Integer(n));
    }

    public ProductionPattern getProductionPatternByName(String string) {
        return (ProductionPattern)this.productionNames.get(string);
    }

    void addDeclaration(String string, String string2) {
        this.declarations.put(string, string2);
    }

    void addToken(TokenPattern tokenPattern, int n, int n2) {
        this.tokens.add(tokenPattern);
        this.tokenIds.put(new Integer(tokenPattern.getId()), tokenPattern);
        this.tokenNames.put(tokenPattern.getName(), tokenPattern);
        if (tokenPattern.getType() == 1) {
            this.tokenPatterns.put(tokenPattern.getPattern(), tokenPattern);
        }
        this.lines.put(tokenPattern.getName(), new LineRange(n, n2));
    }

    void addProduction(ProductionPattern productionPattern, int n, int n2) {
        this.productions.add(productionPattern);
        this.productionIds.put(new Integer(productionPattern.getId()), productionPattern);
        this.productionNames.put(productionPattern.getName(), productionPattern);
        this.lines.put(productionPattern.getName(), new LineRange(n, n2));
    }

    private class LineRange {
        private int start;
        private int end;

        public LineRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

