/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.util.HashMap;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarAnalyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;

class FirstPassAnalyzer
extends GrammarAnalyzer {
    private Grammar grammar;
    private int nextTokenId = 1001;
    private int nextProductionId = 2001;
    private HashMap names = new HashMap();

    public FirstPassAnalyzer(Grammar grammar) {
        this.grammar = grammar;
    }

    protected Node exitIgnore(Token token) {
        String string = token.getImage();
        if (!(string = string.substring(7, string.length() - 1).trim()).equals("")) {
            token.addValue(string);
        }
        return token;
    }

    protected Node exitError(Token token) {
        String string = token.getImage();
        if (!(string = string.substring(6, string.length() - 1).trim()).equals("")) {
            token.addValue(string);
        }
        return token;
    }

    protected Node exitIdentifier(Token token) {
        token.addValue(token.getImage());
        return token;
    }

    protected Node exitQuotedString(Token token) {
        String string = token.getImage();
        token.addValue(string.substring(1, string.length() - 1));
        return token;
    }

    protected Node exitRegexp(Token token) {
        String string = token.getImage();
        StringBuffer stringBuffer = new StringBuffer();
        string = string.substring(2, string.length() - 2);
        for (int i = 0; i < string.length(); ++i) {
            if (string.startsWith("\\<", i)) {
                stringBuffer.append('<');
                ++i;
                continue;
            }
            if (string.startsWith("\\>", i)) {
                stringBuffer.append('>');
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        token.addValue(stringBuffer.toString());
        return token;
    }

    protected Node exitHeaderPart(Production production) {
        return null;
    }

    protected Node exitHeaderDeclaration(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        String string2 = this.getStringValue(this.getChildAt(production, 2), 0);
        this.grammar.addDeclaration(string, string2);
        return null;
    }

    protected Node exitTokenPart(Production production) {
        return null;
    }

    protected Node exitTokenDeclaration(Production production) throws ParseException {
        String string = this.getIdentifier((Token)this.getChildAt(production, 0));
        Node node = this.getChildAt(production, 2);
        int n = this.getIntValue(node, 0);
        String string2 = this.getStringValue(node, 1);
        TokenPattern tokenPattern = new TokenPattern(this.nextTokenId++, string, n, string2);
        if (production.getChildCount() == 4) {
            node = this.getChildAt(production, 3);
            Token token = (Token)this.getValue(node, 0);
            string2 = null;
            if (node.getValueCount() == 2) {
                string2 = this.getStringValue(node, 1);
            }
            switch (token.getId()) {
                case 1004: {
                    if (string2 == null) {
                        tokenPattern.setIgnore();
                        break;
                    }
                    tokenPattern.setIgnore(string2);
                    break;
                }
                case 1005: {
                    if (string2 == null) {
                        tokenPattern.setError();
                        break;
                    }
                    tokenPattern.setError(string2);
                }
            }
        }
        this.grammar.addToken(tokenPattern, production.getStartLine(), production.getEndLine());
        return null;
    }

    protected Node exitTokenValue(Production production) throws ParseException {
        switch (this.getChildAt(production, 0).getId()) {
            case 1020: {
                production.addValue(new Integer(1));
                break;
            }
            case 1021: {
                production.addValue(new Integer(2));
            }
        }
        production.addValue(this.getStringValue(this.getChildAt(production, 0), 0));
        return production;
    }

    protected Node exitTokenHandling(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        production.addValue(node);
        if (node.getValueCount() > 0) {
            production.addValue(this.getValue(node, 0));
        }
        return production;
    }

    protected Node exitProductionDeclaration(Production production) throws ParseException {
        String string = this.getIdentifier((Token)this.getChildAt(production, 0));
        ProductionPattern productionPattern = new ProductionPattern(this.nextProductionId++, string);
        this.grammar.addProduction(productionPattern, production.getStartLine(), production.getEndLine());
        return production;
    }

    private String getIdentifier(Token token) throws ParseException {
        String string = token.getImage();
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        if (token.getId() != 1019) {
            throw new ParseException(0, null, token.getStartLine(), token.getStartColumn());
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if ('A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            stringBuffer.deleteCharAt(i--);
        }
        if (this.names.containsKey(stringBuffer.toString())) {
            throw new ParseException(6, "duplicate identifier '" + string + "' is similar or " + "equal to previously defined identifier '" + this.names.get(stringBuffer.toString()) + "'", token.getStartLine(), token.getStartColumn());
        }
        this.names.put(stringBuffer.toString(), string);
        return string;
    }
}

