/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

public class MibsUtil {
    public static Mib compile(String[] stringArray, String string) throws Exception {
        MibLoader mibLoader = new MibLoader();
        File file = new File(string);
        mibLoader.addDir(file.getParentFile());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                mibLoader.addDir(new File(stringArray[i]));
            }
        }
        Mib mib = mibLoader.load(file);
        return mib;
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        String string = stringArray[0];
        boolean bl = false;
        if (stringArray.length > 1 && stringArray[1].startsWith("/v")) {
            bl = true;
        }
        if ((file = new File(string)).isDirectory()) {
            MibsUtil.testDir(file, bl);
        } else {
            MibsUtil.testFile(file, bl);
        }
    }

    private static void testDir(File file, boolean bl) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return !string.endsWith("zip");
            }
        };
        System.out.println("\nprocessing " + file.getAbsolutePath() + "\n");
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                MibsUtil.testDir(fileArray[i], bl);
                continue;
            }
            MibsUtil.testFile(fileArray[i], bl);
        }
    }

    private static void testFile(File file, boolean bl) {
        try {
            MibsUtil.compile(null, file.getAbsolutePath());
            if (bl) {
                System.out.println("compiled " + file.getAbsolutePath());
            }
        }
        catch (MibLoaderException mibLoaderException) {
            System.out.println("\nException in " + file.getAbsolutePath());
            MibLoaderLog mibLoaderLog = mibLoaderException.getLog();
            Iterator iterator = mibLoaderLog.entries();
            while (iterator.hasNext()) {
                MibLoaderLog.LogEntry logEntry = (MibLoaderLog.LogEntry)iterator.next();
                if (!logEntry.isError()) continue;
                System.out.println(logEntry.getMessage() + " " + logEntry.getLineNumber() + ":" + logEntry.getColumnNumber());
            }
            System.out.println();
        }
        catch (Throwable throwable) {
            System.out.println("Exception in " + file.getAbsolutePath());
            throwable.printStackTrace();
        }
    }
}

