/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.datatypes.BCreateMibParameters;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.export.BSnmpExportFolder;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.object.BSnmpObjectExt;
import com.tridium.snmp.util.LocalToMibSnmpV2;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Array;

public class LocalToMib {
    private StringBuffer out;
    static /* synthetic */ Class class$com$tridium$snmp$export$BSnmpExportFolder;

    public static String createMib(BSnmpAgent bSnmpAgent, BCreateMibParameters bCreateMibParameters) {
        try {
            switch (bCreateMibParameters.getVersion().getOrdinal()) {
                case 1: {
                    LocalToMib localToMib = new LocalToMib();
                    return localToMib.extract(bSnmpAgent, bCreateMibParameters);
                }
                case 2: {
                    LocalToMibSnmpV2 localToMibSnmpV2 = new LocalToMibSnmpV2();
                    return localToMibSnmpV2.extract(bSnmpAgent, bCreateMibParameters);
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "Unable to create MIB:" + throwable.toString();
        }
    }

    private String extract(BSnmpAgent bSnmpAgent, BCreateMibParameters bCreateMibParameters) throws IOException {
        this.out = new StringBuffer();
        int n = bSnmpAgent.getEnterprise();
        this.extractFixed(bCreateMibParameters.getFileName(), n == 0 ? 4131 : n);
        BSnmpExportFolder[] bSnmpExportFolderArray = LocalToMib.getExportFolders(bSnmpAgent);
        for (int i = 0; i < bSnmpExportFolderArray.length; ++i) {
            this.writeExportTable(bSnmpExportFolderArray[i].getDisplayName(null), i + 2);
        }
        this.writeObjects(bSnmpAgent.snmpNet().objects());
        this.writeTrap();
        this.out.append("END\n");
        return this.out.toString();
    }

    private void extractFixed(String string, int n) throws IOException {
        String string2 = string;
        if (string.lastIndexOf(46) > 0) {
            string2 = string.substring(0, string.lastIndexOf(46));
        }
        this.out.append("-- *************************************************\n");
        this.out.append("-- ").append(string).append("\n");
        this.out.append("--\n");
        this.out.append("-- Created:").append(BAbsTime.make().toString((Context)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.TRUE))).append("\n");
        this.out.append("--\n");
        this.out.append("-- Copyright ").append(Calendar.getInstance().get(1)).append(" Tridium, Inc.\n");
        this.out.append("-- *************************************************\n");
        this.out.append("--\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append(string2.toUpperCase()).append(" DEFINITIONS ::= BEGIN\n");
        this.out.append("\n");
        this.out.append("-- MIB II Extension Definitions for hub management\n");
        this.out.append("\n");
        this.out.append("IMPORTS\n");
        this.out.append("         OBJECT-TYPE\n");
        this.out.append("               FROM RFC-1212\n");
        this.out.append("         TRAP-TYPE\n");
        this.out.append("               FROM RFC-1215\n");
        this.out.append("         enterprises, IpAddress, Counter, TimeTicks, Gauge\n");
        this.out.append("               FROM RFC1155-SMI\n");
        this.out.append("         DisplayString\n");
        this.out.append("               FROM RFC1213-MIB;\n");
        this.out.append("\n");
        this.out.append("    tridium           OBJECT IDENTIFIER ::= { enterprises ").append(n).append(" }\n");
        this.out.append("    tridiumStation    OBJECT IDENTIFIER ::= { tridium 1 }\n");
        this.out.append("\n");
        this.out.append("version    OBJECT-TYPE\n");
        this.out.append("    SYNTAX     DisplayString\n");
        this.out.append("    ACCESS     read-only\n");
        this.out.append("    STATUS     mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Current software version\"\n");
        this.out.append("    ::=  { tridiumStation 1 }\n");
        this.out.append("\n");
        this.out.append("action   OBJECT-TYPE\n");
        this.out.append("    SYNTAX            INTEGER{\n");
        this.out.append("                       noAction(0),\n");
        this.out.append("                       ackAll(1)\n");
        this.out.append("                      }\n");
        this.out.append("    ACCESS            read-write\n");
        this.out.append("    STATUS            mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Provides means for manager to perform actions on the alarm table. 0 (no action) or 1 (acknowledge all).\"\n");
        this.out.append("    ::=  { tridiumStation 2 }\n");
        this.out.append("\n");
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  Alarm table declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("alarmTable   OBJECT-TYPE\n");
        this.out.append("    SYNTAX                SEQUENCE OF AlarmTableEntry\n");
        this.out.append("    ACCESS                not-accessible\n");
        this.out.append("    STATUS                mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A list of alarms in the station which have an snmp recipient (configured to store received alarms).\"\n");
        this.out.append("    ::=  { tridiumStation 3 }\n");
        this.out.append("\n");
        this.out.append("alarmTableEntry  OBJECT-TYPE\n");
        this.out.append("    SYNTAX                AlarmTableEntry\n");
        this.out.append("    ACCESS                not-accessible\n");
        this.out.append("    STATUS                mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"An alarm table entry containing data for a specific alarm.\"\n");
        this.out.append("    INDEX  { alarmId }  ::=   { alarmTable 1 }\n");
        this.out.append("\n");
        this.out.append("AlarmTableEntry ::= SEQUENCE {\n");
        this.out.append("        timestamp        DisplayString,\n");
        this.out.append("        uuid             OCTET STRING,\n");
        this.out.append("        sourceState      INTEGER,\n");
        this.out.append("        ackState         INTEGER,\n");
        this.out.append("        ackRequired      INTEGER,\n");
        this.out.append("        source           DisplayString,\n");
        this.out.append("        alarmClass       DisplayString,\n");
        this.out.append("        priority         INTEGER,\n");
        this.out.append("        normalTime       DisplayString,\n");
        this.out.append("        ackTime          DisplayString,\n");
        this.out.append("        user             DisplayString,\n");
        this.out.append("        alarmData        DisplayString,\n");
        this.out.append("        alarmTransition  INTEGER,\n");
        this.out.append("        lastUpdate       DisplayString,\n");
        this.out.append("        alarmId          INTEGER\n");
        this.out.append("    }\n");
        this.out.append("\n");
        this.out.append("timestamp   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates the time when the alarm occurred.\"\n");
        this.out.append("    ::=   { alarmTableEntry 1 }\n");
        this.out.append("\n");
        this.out.append("uuid   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           OCTET STRING(SIZE(0..255))\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The unique universal identifier of the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 2 }\n");
        this.out.append("\n");
        this.out.append("sourceState   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER {\n");
        this.out.append("                       normal(0),\n");
        this.out.append("                       offnormal(1),\n");
        this.out.append("                       fault(2),\n");
        this.out.append("                       alert(3)\n");
        this.out.append("                     }\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The current state of the source.  normal(0), offnormal(1), fault(2), or alert(3).\"\n");
        this.out.append("    ::=   { alarmTableEntry 3 }\n");
        this.out.append("\n");
        this.out.append("ackState   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER {\n");
        this.out.append("                       acked(0),\n");
        this.out.append("                       unacked(1),\n");
        this.out.append("                       ackPending(2)\n");
        this.out.append("                     }\n");
        this.out.append("    ACCESS           read-write\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates if the alarm has been acknowledged.  acked(0), unacked(1), or ackPending(2).\n");
        this.out.append("     Alarm can be acknowledged by setting ackState to 'acked'(0)\"\n");
        this.out.append("    ::=   { alarmTableEntry 4 }\n");
        this.out.append("\n");
        this.out.append("ackRequired   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER {\n");
        this.out.append("                       false(0),\n");
        this.out.append("                       true(1)\n");
        this.out.append("                     }\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates if an acknowledgement is required for the alarm.  false(0), or true(1).\"\n");
        this.out.append("    ::=   { alarmTableEntry 5 }\n");
        this.out.append("\n");
        this.out.append("source    OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Indicates the path to the station object which generated the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 6 }\n");
        this.out.append("\n");
        this.out.append("alarmClass  OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The alarm class for the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 7 }\n");
        this.out.append("\n");
        this.out.append("priority   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER(0..255)\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The priority of the alarm (0=high, 255=low).\"\n");
        this.out.append("    ::=   { alarmTableEntry 8 }\n");
        this.out.append("\n");
        this.out.append("normalTime   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm goes back to normal state.\"\n");
        this.out.append("    ::=   { alarmTableEntry 9 }\n");
        this.out.append("\n");
        this.out.append("ackTime  OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm is acked. Note that\n");
        this.out.append("     interpretation of this value depends upon the state of the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 10 }\n");
        this.out.append("\n");
        this.out.append("user   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The name of the user who acknowledged the alarm.\"\n");
        this.out.append("    ::=   { alarmTableEntry 11 }\n");
        this.out.append("\n");
        this.out.append("alarmData     OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A string containing dynamic alarm data, in key-value pairs.\"\n");
        this.out.append("    ::=   { alarmTableEntry 12 }\n");
        this.out.append("\n");
        this.out.append("alarmTransition   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER {\n");
        this.out.append("                       normal(0),\n");
        this.out.append("                       offnormal(1),\n");
        this.out.append("                       fault(2),\n");
        this.out.append("                       alert(3)\n");
        this.out.append("                     }\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The initial state of the source.  normal(0), offnormal(1), fault(2), or alert(3).\"\n");
        this.out.append("    ::=   { alarmTableEntry 13 }\n");
        this.out.append("\n");
        this.out.append("lastUpdate  OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The time at which the alarm was last updated. Updates occur\n");
        this.out.append("     at creation, acknowlegement, and changes to alarmData such as notes.\"\n");
        this.out.append("    ::=   { alarmTableEntry 14 }\n");
        this.out.append("\n");
        this.out.append("alarmId   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER(0..2147483647)\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Numerical identifier for the alarm in the Snmp alarm table.\n");
        this.out.append("     Used as an index to address table entries\"\n");
        this.out.append("    ::=   { alarmTableEntry 15 }\n");
        this.out.append("\n");
        this.writeTable("tridiumStation 4", "Input", true);
        this.writeTable("tridiumStation 5", "Output", false);
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ExportTables\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("    exportTables    OBJECT IDENTIFIER ::= { tridiumStation 6 }\n");
        this.out.append("\n");
        this.writeExportTable("export", 1);
    }

    private void writeExportTable(String string, int n) {
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        String string3 = string.substring(0, 1).toUpperCase() + string.substring(1);
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ").append(string3).append("\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("    ").append(string2).append("    OBJECT IDENTIFIER ::= { exportTables ").append(n).append(" }\n");
        this.writeTable(string2 + " 1", string2 + "Input", true);
        this.writeTable(string2 + " 2", string2 + "Output", false);
    }

    private void writeTable(String string, String string2, boolean bl) {
        String string3 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
        String string4 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        String string5 = bl ? "read-write" : "read-only";
        this.out.append("\n-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  ").append(string4).append(" table declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append(string3).append("Table   OBJECT-TYPE\n");
        this.out.append("    SYNTAX                SEQUENCE OF ").append(string4).append("TableEntry\n");
        this.out.append("    ACCESS                not-accessible\n");
        this.out.append("    STATUS                mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"A list of snmp ").append(string3).append(" (read-only) object values.\"\n");
        this.out.append("    ::=  { ").append(string).append(" }\n");
        this.out.append("\n");
        this.out.append(string3).append("TableEntry  OBJECT-TYPE\n");
        this.out.append("    SYNTAX                ").append(string4).append("TableEntry\n");
        this.out.append("    ACCESS                not-accessible\n");
        this.out.append("    STATUS                mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"An ").append(string3).append(" table entry containing data for a specific ").append(string3).append(".\"\n");
        this.out.append("    INDEX  { ").append(string3).append("Index }  ::=   { ").append(string3).append("Table 1 }\n");
        this.out.append("\n");
        this.out.append(string4).append("TableEntry ::= SEQUENCE {\n");
        this.out.append("        ").append(string3).append("Index       INTEGER,\n");
        this.out.append("        ").append(string3).append("Name        DisplayString,\n");
        this.out.append("        ").append(string3).append("Value       DisplayString\n");
        this.out.append("    }\n");
        this.out.append("\n");
        this.out.append(string3).append("Index   OBJECT-TYPE\n");
        this.out.append("    SYNTAX           INTEGER(0..2147483647)\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"The index in the ").append(string3).append(" table for a particular snmp ").append(string3).append("\n");
        this.out.append("\t object.  Used to address table entries.\"\n");
        this.out.append("    ::=   { ").append(string3).append("TableEntry 1 }\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append(string3).append("Name    OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           read-only\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Name of station object.\"\n");
        this.out.append("    ::=   { ").append(string3).append("TableEntry 2 }\n");
        this.out.append("\n");
        this.out.append(string3).append("Value    OBJECT-TYPE\n");
        this.out.append("    SYNTAX           DisplayString\n");
        this.out.append("    ACCESS           ").append(string5).append("\n");
        this.out.append("    STATUS           mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("    \"Current value of station object. Is ").append(string5).append(" .\"\n");
        this.out.append("    ::=   { ").append(string3).append("TableEntry 3 }\n");
        this.out.append("\n\n");
    }

    private void writeObjects(PointTable pointTable) throws IOException {
        TableEntry[] tableEntryArray = pointTable.getArray();
        if (tableEntryArray.length == 0) {
            return;
        }
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  Niagara Objects\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("    niagaraObjects    OBJECT IDENTIFIER ::= { tridiumStation 7 }\n");
        this.out.append("\n");
        for (int i = 0; i < tableEntryArray.length; ++i) {
            BSnmpObjectExt bSnmpObjectExt = (BSnmpObjectExt)tableEntryArray[i];
            BSnmpVariableTypeEnum bSnmpVariableTypeEnum = bSnmpObjectExt.getVariableType();
            String string = this.fixIdentifierName(bSnmpObjectExt.getPointName());
            if (bSnmpVariableTypeEnum == BSnmpVariableTypeEnum.counter64) {
                this.out.append("-- type counter64 not valid for SNMPv1 MIB - ").append(string).append("\n\n");
                continue;
            }
            this.out.append(string).append("   OBJECT-TYPE\n");
            this.out.append("    SYNTAX           ");
            switch (bSnmpVariableTypeEnum.getOrdinal()) {
                case 0: {
                    int[] nArray;
                    BEnumRange bEnumRange = (BEnumRange)((BControlPoint)bSnmpObjectExt.getParent()).getFacets().getFacet("range");
                    if (bEnumRange != null && (nArray = bEnumRange.getOrdinals()).length > 0) {
                        Arrays.sort(nArray);
                        this.out.append("    INTEGER {\n");
                        for (int j = 0; j < nArray.length; ++j) {
                            this.out.append("                           " + SlotPath.unescape((String)bEnumRange.getTag(nArray[j])) + "(" + nArray[j] + ")");
                            this.out.append(j < nArray.length - 1 ? ",\n" : "\n");
                        }
                        this.out.append("                         }\n");
                        break;
                    }
                    this.out.append("    INTEGER\n");
                    break;
                }
                case 2: {
                    this.out.append("    Counter\n");
                    break;
                }
                case 3: {
                    this.out.append("    Gauge\n");
                    break;
                }
                case 1: {
                    this.out.append("    OCTET STRING\n");
                    break;
                }
                case 6: {
                    this.out.append("    IpAddress\n");
                    break;
                }
                case 7: {
                    this.out.append("    OBJECT IDENTIFIER\n");
                    break;
                }
                case 4: {
                    this.out.append("    TimeTicks\n");
                }
            }
            this.out.append("    ACCESS           ").append(bSnmpObjectExt.isSettablePoint() ? "read-write" : "read-only").append("\n");
            this.out.append("    STATUS           mandatory\n");
            if (bSnmpObjectExt.getDescription().length() > 0) {
                this.out.append("    DESCRIPTION\n");
                this.out.append("    \"").append(bSnmpObjectExt.getDescription()).append("\"\n");
            }
            this.out.append("    ::=   { niagaraObjects ").append(bSnmpObjectExt.getIndex()).append(" }\n");
            this.out.append("\n");
        }
    }

    private String fixIdentifierName(String string) {
        if (!Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string;
    }

    private void writeTrap() {
        this.out.append("-- ***********************************\n");
        this.out.append("-- *\n");
        this.out.append("-- *  Alarm trap declarations\n");
        this.out.append("-- *\n");
        this.out.append("-- ***********************************\n");
        this.out.append("\n");
        this.out.append("\n");
        this.out.append("stationAlarm TRAP-TYPE\n");
        this.out.append("-- Non-reverse mappable trap\n");
        this.out.append("    ENTERPRISE tridiumStation\n");
        this.out.append("    VARIABLES { timestamp,\n");
        this.out.append("                uuid,\n");
        this.out.append("                sourceState,\n");
        this.out.append("                ackState,\n");
        this.out.append("                ackRequired,\n");
        this.out.append("                source,\n");
        this.out.append("                alarmClass,\n");
        this.out.append("                priority,\n");
        this.out.append("                normalTime,\n");
        this.out.append("                ackTime,\n");
        this.out.append("                user,\n");
        this.out.append("                alarmData,\n");
        this.out.append("                alarmTransition,\n");
        this.out.append("                lastUpdate }\n");
        this.out.append("--  Status\n");
        this.out.append("--    mandatory\n");
        this.out.append("    DESCRIPTION\n");
        this.out.append("        \"The stationAlarm trap is generated when a Niagara alarm is received\n");
        this.out.append("         by an snmp recipient which has routing alarms to a network manager\n");
        this.out.append("         enabled.  It contains useful information from the alarm record.\"\n");
        this.out.append("    ::= 1\n");
        this.out.append("\n");
        this.out.append("\n");
    }

    public static BSnmpExportFolder[] getExportFolders(BSnmpAgent bSnmpAgent) {
        Array array = new Array(class$com$tridium$snmp$export$BSnmpExportFolder == null ? (class$com$tridium$snmp$export$BSnmpExportFolder = LocalToMib.class$("com.tridium.snmp.export.BSnmpExportFolder")) : class$com$tridium$snmp$export$BSnmpExportFolder);
        LocalToMib.getExportFolders((BComponent)bSnmpAgent, array);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((BSnmpExportFolder)object).getObjectIdentifier().compareTo(((BSnmpExportFolder)object2).getObjectIdentifier());
            }
        };
        array.sort(comparator);
        return (BSnmpExportFolder[])array.trim();
    }

    private static void getExportFolders(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            BObject bObject = slotCursor.get();
            if (bObject instanceof BSnmpExportFolder) {
                array.add((Object)bObject);
                continue;
            }
            if (!(bObject instanceof BComponent)) continue;
            LocalToMib.getExportFolders((BComponent)bObject, array);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

