/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.datatypes.BMibListEntry;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSnmpWalkMibJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$util$BSnmpWalkMibJob == null ? (class$com$tridium$snmp$util$BSnmpWalkMibJob = BSnmpWalkMibJob.class$("com.tridium.snmp.util.BSnmpWalkMibJob")) : class$com$tridium$snmp$util$BSnmpWalkMibJob));
    BSnmpDevice device;
    BMibListTable mibTable;
    public static BIcon icon = BIcon.std((String)"find.png");
    BSnmpPointDeviceExt deviceExt;
    boolean walkCanceled = false;
    static /* synthetic */ Class class$com$tridium$snmp$util$BSnmpWalkMibJob;

    public Type getType() {
        return TYPE;
    }

    public BSnmpWalkMibJob() {
    }

    public BSnmpWalkMibJob(BSnmpDevice bSnmpDevice, BMibListTable bMibListTable) {
        this.device = bSnmpDevice;
        this.mibTable = bMibListTable;
    }

    public void doCancel(Context context) {
        this.walkCanceled = true;
        super.doCancel(context);
    }

    public void run(Context context) throws Exception {
        this.progress(0);
        this.log().start("Walking MIB...");
        BMibListEntry[] bMibListEntryArray = this.mibTable.getPointListCopy();
        int n = bMibListEntryArray.length;
        if (n <= 0) {
            n = 1;
        }
        int n2 = 0;
        for (int i = 0; i < bMibListEntryArray.length && !this.walkCanceled; ++i) {
            Object object;
            Object object2;
            this.progress((int)((float)n2 / (float)n * 100.0f));
            ++n2;
            BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = bMibListEntryArray[i].getElementType();
            if (bSnmpMipEntryTypeEnum.equals((Object)BSnmpMipEntryTypeEnum.sequenceElement)) {
                boolean bl = true;
                object = object2 = bMibListEntryArray[i].getOid();
                this.log().message("Reading table values for " + bMibListEntryArray[i].getEntryName() + " (" + (String)object + ")...");
                bMibListEntryArray[i].clearChildren();
                int n3 = 1;
                while (bl && !this.walkCanceled) {
                    SnmpPDU snmpPDU = this.device.updateGetNext((String)object);
                    if (snmpPDU == null) {
                        bl = false;
                        continue;
                    }
                    Vector vector = snmpPDU.getVariableBindings();
                    if (vector == null || vector.size() <= 0) {
                        bl = false;
                        continue;
                    }
                    SnmpVarBind snmpVarBind = (SnmpVarBind)vector.elementAt(0);
                    String string = snmpVarBind.getObjectID().toString();
                    if (string.startsWith((String)object2) && !string.equals(object2) && !string.equals(object)) {
                        String string2;
                        Object object3;
                        int n4 = string.lastIndexOf(46);
                        if (n4 >= 0 && n4 + 1 < string.length()) {
                            object3 = string.substring(((String)object2).length() + 1);
                            string2 = bMibListEntryArray[i].getEntryName() + "_" + (String)object3;
                        } else {
                            string2 = bMibListEntryArray[i].getEntryName() + "_" + n3;
                        }
                        object3 = new BMibListEntry(string2, string, bMibListEntryArray[i].getObjectSyntax(), bMibListEntryArray[i].getVariableType(), bMibListEntryArray[i].getAccess(), bMibListEntryArray[i].getStatus(), bMibListEntryArray[i].getDesc(), BSnmpMipEntryTypeEnum.sequenceValue);
                        ((BMibListEntry)((Object)object3)).setValue(snmpVarBind.getVariable().toStringValue());
                        ((BMibListEntry)((Object)object3)).setEnumRange(bMibListEntryArray[i].getEnumRange());
                        bMibListEntryArray[i].addChild((BMibListEntry)((Object)object3));
                        object = string;
                    } else {
                        bl = false;
                    }
                    ++n3;
                }
                continue;
            }
            if (!bSnmpMipEntryTypeEnum.isAccessibleValue()) continue;
            String string = bMibListEntryArray[i].getOid();
            this.log().message("Reading present value for " + bMibListEntryArray[i].getEntryName() + " (" + string + ")...");
            object2 = this.device.updateGet(string);
            if (object2 == null || (object = ((SnmpPDU)object2).getVariableBindings()) == null || ((Vector)object).size() <= 0) continue;
            SnmpVarBind snmpVarBind = (SnmpVarBind)((Vector)object).elementAt(0);
            bMibListEntryArray[i].setValue(snmpVarBind.getVariable().toStringValue());
        }
        if (this.walkCanceled) {
            throw new JobCancelException();
        }
        this.log().success("MIB Walk Complete");
        ((BSnmpPointDeviceExt)this.device.getPoints()).fireMibWalkedEvent(new BMibListTable(bMibListEntryArray));
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

