/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.alarm.BSnmpAlarmDeviceExt;
import com.tridium.snmp.alarm.BTrapType;
import com.tridium.snmp.datatypes.BMibListEntry;
import com.tridium.snmp.datatypes.BStringArray;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.mib.OidUtil;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.ui.BMibPathDialog;
import com.tridium.snmp.ui.BSnmpPointManager;
import com.tridium.snmp.util.SnmpUtil;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import net.percederberg.mibble.Mib;

public class BSnmpTrapManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpTrapManager == null ? (class$com$tridium$snmp$ui$BSnmpTrapManager = BSnmpTrapManager.class$("com.tridium.snmp.ui.BSnmpTrapManager")) : class$com$tridium$snmp$ui$BSnmpTrapManager));
    static BImage snmpTrapIcon = BImage.make((String)"module://icons/x16/shapes/rectBlue.png");
    static Lexicon lexicon = Lexicon.make((Class)(class$com$tridium$snmp$ui$BSnmpTrapManager == null ? (class$com$tridium$snmp$ui$BSnmpTrapManager = BSnmpTrapManager.class$("com.tridium.snmp.ui.BSnmpTrapManager")) : class$com$tridium$snmp$ui$BSnmpTrapManager));
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colTrapName = new MgrColumn.Prop(BTrapType.trapName, 3);
    MgrColumn colOid = new MgrColumn.Prop(BTrapType.trapOid, 3);
    MgrColumn colGeneric = new MgrColumn.Prop(BTrapType.genericType, 3);
    MgrColumn colSpecific = new MgrColumn.Prop(BTrapType.specificType, 3);
    MgrColumn colVariables = new MgrColumn.Prop(BTrapType.variablesArray, 3);
    MgrColumn colReference = new MgrColumn.Prop(BTrapType.reference, 3);
    MgrColumn colDesc = new MgrColumn.Prop(BTrapType.description, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colTrapName, this.colOid, this.colGeneric, this.colSpecific, this.colVariables, this.colReference, this.colDesc};
    MgrColumn dcolName = new MgrColumn.Prop(lexicon.getText("table.columnTitle.name"), BMibListEntry.entryName, 0);
    MgrColumn dcolOid = new MgrColumn.Prop(lexicon.getText("table.columnTitle.oid"), BMibListEntry.oid, 0);
    MgrColumn dcolType = new MgrColumn.Prop(lexicon.getText("table.columnTitle.type"), BMibListEntry.variableType, 2);
    MgrColumn dcolValue = new MgrColumn.Prop(lexicon.getText("table.columnTitle.value"), BMibListEntry.value, 0);
    MgrColumn dcolAccess = new MgrColumn.Prop(lexicon.getText("table.columnTitle.access"), BMibListEntry.access, 2);
    MgrColumn dcolStatus = new MgrColumn.Prop(lexicon.getText("table.columnTitle.status"), BMibListEntry.status, 2);
    MgrColumn dcolElementType = new MgrColumn.Prop(lexicon.getText("table.columnTitle.elementType"), BMibListEntry.elementType, 2);
    MgrColumn dcolDesc = new MgrColumn.Prop(lexicon.getText("table.columnTitle.description"), BMibListEntry.desc, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolOid, this.dcolType, this.dcolValue, this.dcolAccess, this.dcolStatus, this.dcolElementType, this.dcolDesc};
    BSnmpAlarmDeviceExt storedTraps;
    BSnmpDevice device;
    boolean isCheckingExistence = false;
    boolean discoveryInProcess = false;
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpTrapManager;
    static /* synthetic */ Class class$com$tridium$snmp$datatypes$BMibListEntry;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpTrapModel(this);
    }

    protected MgrController makeController() {
        return new SnmpTrapController(this);
    }

    protected MgrLearn makeLearn() {
        return new SnmpTrapLearn(this);
    }

    protected MgrState makeState() {
        return new SnmpTrapState();
    }

    private static String parseDescription(String string) {
        String string2 = "";
        int n = string.lastIndexOf("; DESCRIPTION=") + 14;
        int n2 = string.lastIndexOf("; REFERENCE=");
        if (n > -1 && n < n2) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    private static String parseReference(String string) {
        String string2 = "";
        int n = string.lastIndexOf("; REFERENCE=") + 12;
        int n2 = string.length();
        if (n > -1 && n < n2) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    private static int parseGenericType(String string) {
        int n = -1;
        int n2 = string.indexOf("GENERIC=") + 8;
        int n3 = string.indexOf("; SPECIFIC=");
        if (n2 > -1 && n2 < n3) {
            n = Integer.parseInt(string.substring(n2, n3));
        }
        return n;
    }

    private static int parseSpecificType(String string) {
        int n = -1;
        int n2 = string.indexOf("; SPECIFIC=") + 11;
        int n3 = string.indexOf(";", n2);
        if (n2 > -1 && n2 < n3) {
            n = Integer.parseInt(string.substring(n2, n3));
        }
        return n;
    }

    private static String[] parseVariables(String string) {
        int n = string.lastIndexOf("; VARIABLES=") + 12;
        int n2 = string.lastIndexOf("; DESCRIPTION=");
        return SnmpUtil.getStringArray(string.substring(n, n2));
    }

    private static String[] parseObjects(String string) {
        int n = string.lastIndexOf("OBJECTS=") + 8;
        int n2 = string.lastIndexOf("; DESCRIPTION=");
        return SnmpUtil.getStringArray(string.substring(n, n2));
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.storedTraps = (BSnmpAlarmDeviceExt)bObject;
        this.device = (BSnmpDevice)this.storedTraps.getDevice();
        super.doLoadValue(bObject, context);
    }

    private BMibListEntry[] buildEntries(Mib mib) {
        OidElement oidElement = OidUtil.createOidEntries(mib, this.device.snmpNet());
        OidEntry[] oidEntryArray = oidElement.getOidEntries();
        if (oidEntryArray == null) {
            return new BMibListEntry[0];
        }
        HashMap<String, OidEntry> hashMap = new HashMap<String, OidEntry>();
        Array array = new Array(class$com$tridium$snmp$datatypes$BMibListEntry == null ? (class$com$tridium$snmp$datatypes$BMibListEntry = BSnmpTrapManager.class$("com.tridium.snmp.datatypes.BMibListEntry")) : class$com$tridium$snmp$datatypes$BMibListEntry, oidEntryArray.length);
        for (int i = 0; i < oidEntryArray.length; ++i) {
            try {
                OidEntry oidEntry = oidEntryArray[i];
                BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = oidEntry.getElementType();
                if (!bSnmpMipEntryTypeEnum.equals((Object)BSnmpMipEntryTypeEnum.trap) && !bSnmpMipEntryTypeEnum.equals((Object)BSnmpMipEntryTypeEnum.notification) || hashMap.get(oidEntry.getOid()) != null) continue;
                hashMap.put(oidEntry.getOid(), oidEntry);
                BMibListEntry bMibListEntry = new BMibListEntry();
                String string = oidEntry.getOid();
                bMibListEntry.setOid(string);
                bMibListEntry.setAccess(oidEntry.getAccess());
                bMibListEntry.setEntryName(oidEntry.getName());
                bMibListEntry.setStatus(oidEntry.getStatus());
                bMibListEntry.setDesc(oidEntry.getDesc());
                bMibListEntry.setObjectSyntax(oidEntry.getObjSyntax());
                if (oidEntry.getVariableType() != null) {
                    bMibListEntry.setVariableType(oidEntry.getVariableType());
                }
                bMibListEntry.setElementType(oidEntry.getElementType());
                array.add((Object)bMibListEntry);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return (BMibListEntry[])array.trim();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.isCheckingExistence) {
            return;
        }
        super.handleComponentEvent(bComponentEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConfigAutoMibs
    extends MgrController.MgrCommand {
        private BSnmpTrapManager manager;

        ConfigAutoMibs(BSnmpTrapManager bSnmpTrapManager2) {
            super((BWidget)bSnmpTrapManager2, lexicon.getText("mibPathDialog.command.label"));
            this.manager = bSnmpTrapManager2;
        }

        public CommandArtifact doInvoke() throws Exception {
            BMibPathDialog bMibPathDialog = new BMibPathDialog(this.manager);
            bMibPathDialog.open();
            return null;
        }
    }

    class SnmpTrapController
    extends MgrController {
        private MgrController.MgrCommand configAutoMibs;

        SnmpTrapController(BSnmpTrapManager bSnmpTrapManager2) {
            super((BAbstractManager)bSnmpTrapManager2);
            this.configAutoMibs = new ConfigAutoMibs(bSnmpTrapManager2);
            if (bSnmpTrapManager2.isLearnable()) {
                this.configAutoMibs.setFlags(1);
            }
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] iMgrCommandArray = super.makeCommands();
            int n = 0;
            if (iMgrCommandArray != null) {
                n = iMgrCommandArray.length;
            }
            MgrController.IMgrCommand[] iMgrCommandArray2 = new MgrController.IMgrCommand[n + 1];
            for (int i = 0; i < n; ++i) {
                iMgrCommandArray2[i] = iMgrCommandArray[i];
            }
            iMgrCommandArray2[n] = this.configAutoMibs;
            return iMgrCommandArray2;
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand iMgrCommand) {
            if (iMgrCommand == this.discover) {
                return new MgrController.IMgrCommand[]{this.configAutoMibs};
            }
            return super.getDropDownCommands(iMgrCommand);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            BSnmpTrapManager bSnmpTrapManager = (BSnmpTrapManager)this.getManager();
            if (!BSnmpPointManager.loadMibCompiler(bSnmpTrapManager, BSnmpTrapManager.this.device)) {
                return null;
            }
            Mib mib = BSnmpPointManager.createMib(bSnmpTrapManager, BSnmpTrapManager.this.device);
            if (mib != null) {
                BMibListEntry[] bMibListEntryArray = BSnmpTrapManager.this.buildEntries(mib);
                ((SnmpTrapLearn)BSnmpTrapManager.this.getLearn()).updateTable(bMibListEntryArray);
            }
            return super.doDiscover(context);
        }
    }

    class SnmpTrapState
    extends MgrState {
        BMibListEntry[] lastLearn;

        SnmpTrapState() {
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BSnmpTrapManager bSnmpTrapManager = (BSnmpTrapManager)bAbstractManager;
            SnmpTrapLearn snmpTrapLearn = (SnmpTrapLearn)bSnmpTrapManager.getLearn();
            this.lastLearn = snmpTrapLearn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BSnmpTrapManager bSnmpTrapManager = (BSnmpTrapManager)bAbstractManager;
            SnmpTrapLearn snmpTrapLearn = (SnmpTrapLearn)bSnmpTrapManager.getLearn();
            if (this.lastLearn != null) {
                snmpTrapLearn.updateTable(this.lastLearn);
            }
        }
    }

    class SnmpTrapLearn
    extends MgrLearn {
        BMibListEntry[] lastLearn;

        SnmpTrapLearn(BSnmpTrapManager bSnmpTrapManager2) {
            super((BAbstractManager)bSnmpTrapManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpTrapManager.this.dcols;
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return true;
        }

        public BImage getIcon(Object object) {
            return snmpTrapIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BTrapType.TYPE)};
            return mgrTypeInfoArray;
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            String[] stringArray;
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            String string = bMibListEntry.getEntryName();
            String string2 = BSnmpTrapManager.parseDescription(bMibListEntry.getDesc());
            String string3 = BSnmpTrapManager.parseReference(bMibListEntry.getDesc());
            int n = BSnmpTrapManager.parseGenericType(bMibListEntry.getDesc());
            int n2 = BSnmpTrapManager.parseSpecificType(bMibListEntry.getDesc());
            if (bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.trap)) {
                stringArray = BSnmpTrapManager.parseVariables(bMibListEntry.getDesc());
            } else if (bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.notification)) {
                stringArray = BSnmpTrapManager.parseObjects(bMibListEntry.getDesc());
            } else {
                return;
            }
            mgrEditRow.setDefaultName(SlotPath.escape((String)string));
            mgrEditRow.setCell(BSnmpTrapManager.this.colTrapName, (BValue)BString.make((String)string));
            mgrEditRow.setCell(BSnmpTrapManager.this.colOid, (BValue)BString.make((String)bMibListEntry.getOid()));
            mgrEditRow.setCell(BSnmpTrapManager.this.colGeneric, (BValue)BInteger.make((int)n));
            mgrEditRow.setCell(BSnmpTrapManager.this.colSpecific, (BValue)BInteger.make((int)n2));
            mgrEditRow.setCell(BSnmpTrapManager.this.colVariables, (BValue)new BStringArray(stringArray));
            mgrEditRow.setCell(BSnmpTrapManager.this.colReference, (BValue)BString.make((String)string3));
            mgrEditRow.setCell(BSnmpTrapManager.this.colDesc, (BValue)BString.make((String)string2));
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            BTrapType bTrapType;
            String string;
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            BTrapType bTrapType2 = (BTrapType)bComponent;
            if (bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.trap)) {
                string = bMibListEntry.getEntryName();
                String string2 = BSnmpTrapManager.parseDescription(bMibListEntry.getDesc());
                String string3 = BSnmpTrapManager.parseReference(bMibListEntry.getDesc());
                SnmpOID snmpOID = new SnmpOID(bMibListEntry.getOid());
                String[] stringArray = BSnmpTrapManager.parseVariables(bMibListEntry.getDesc());
                int n = BSnmpTrapManager.parseGenericType(bMibListEntry.getDesc());
                int n2 = BSnmpTrapManager.parseSpecificType(bMibListEntry.getDesc());
                bTrapType = new BTrapType(string, string2, string3, stringArray, snmpOID.toValue(), n, n2);
            } else if (bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.notification)) {
                string = bMibListEntry.getEntryName();
                String string4 = BSnmpTrapManager.parseDescription(bMibListEntry.getDesc());
                String string5 = BSnmpTrapManager.parseReference(bMibListEntry.getDesc());
                SnmpOID snmpOID = new SnmpOID(bMibListEntry.getOid());
                String[] stringArray = BSnmpTrapManager.parseObjects(bMibListEntry.getDesc());
                bTrapType = new BTrapType(string, string4, string5, stringArray, snmpOID.toValue());
            } else {
                return false;
            }
            BSnmpTrapManager.this.isCheckingExistence = true;
            boolean bl = bTrapType2.compareTraps(bTrapType);
            BSnmpTrapManager.this.isCheckingExistence = false;
            return bl;
        }

        public void updateTable(BMibListEntry[] bMibListEntryArray) {
            this.lastLearn = bMibListEntryArray;
            this.updateRoots((Object[])bMibListEntryArray);
        }
    }

    class SnmpTrapModel
    extends MgrModel {
        SnmpTrapModel(BSnmpTrapManager bSnmpTrapManager2) {
            super((BAbstractManager)bSnmpTrapManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpTrapManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BTrapType.TYPE)};
            return mgrTypeInfoArray;
        }
    }
}

