/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BCreateMibParameters;
import com.tridium.snmp.datatypes.BSnmpVersions;
import com.tridium.snmp.ui.BSnmpAutoMibOptions;
import com.tridium.snmp.util.SnmpUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.nav.BComponentMenuAgent;
import java.io.PrintWriter;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;

public class BSnmpLocalDeviceMenuAgent
extends BComponentMenuAgent {
    public static final BSnmpLocalDeviceMenuAgent INSTANCE = new BSnmpLocalDeviceMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpLocalDeviceMenuAgent == null ? (class$com$tridium$snmp$ui$BSnmpLocalDeviceMenuAgent = BSnmpLocalDeviceMenuAgent.class$("com.tridium.snmp.ui.BSnmpLocalDeviceMenuAgent")) : class$com$tridium$snmp$ui$BSnmpLocalDeviceMenuAgent));
    public static BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static Lexicon lex = Lexicon.make((String)"snmp");
    BTextField fileNameTF;
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpLocalDeviceMenuAgent;

    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget bWidget, BObject bObject, Context context) {
        BMenu bMenu = super.doMakeMenu(bWidget, bObject, context);
        if (!((BComponent)bObject).isMounted()) {
            return bMenu;
        }
        if (((BComponent)bObject).getComponentSpace() != null) {
            CreateMipCommand createMipCommand = new CreateMipCommand(bWidget, bObject);
            bMenu.add("CreateMib", (Command)createMipCommand);
            bMenu.add(null, (BValue)new BSeparator());
            Property[] propertyArray = bMenu.getDynamicPropertiesArray();
            for (int i = 0; i < propertyArray.length - 3; ++i) {
                if (!propertyArray[i].getType().is(BActionMenuItem.TYPE)) continue;
                Property property = propertyArray[propertyArray.length - 3];
                Property property2 = propertyArray[propertyArray.length - 2];
                Property property3 = propertyArray[propertyArray.length - 1];
                System.arraycopy(propertyArray, i, propertyArray, i + 3, propertyArray.length - i - 3);
                propertyArray[i] = property;
                propertyArray[i + 1] = property2;
                propertyArray[i + 2] = property3;
                break;
            }
            bMenu.reorder(propertyArray);
        }
        return bMenu;
    }

    boolean verifyFileExists(String string) {
        try {
            BOrd bOrd = SnmpUtil.absolutePathToDirOrd(string);
            BDirectory bDirectory = (BDirectory)bOrd.resolve().get();
            String string2 = string.substring(string.lastIndexOf(92) + 1);
            FilePath filePath = new FilePath(bDirectory.getFilePath().getBody() + "/" + string2);
            bDirectory.getFileSpace().makeFile(filePath);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Browse
    extends Command {
        public boolean fileSetFromBrowser = false;

        public Browse(BWidget bWidget) {
            super(bWidget, "");
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd;
            BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.getShell());
            String string = BSnmpLocalDeviceMenuAgent.this.fileNameTF.getText();
            if (string.lastIndexOf(92) > 0) {
                bFileChooser.setCurrentDirectory(SnmpUtil.absolutePathToDirOrd(string));
            }
            if ((bOrd = bFileChooser.show()) != null) {
                BSnmpLocalDeviceMenuAgent.this.fileNameTF.setText(SnmpUtil.ordToAbsolutePath(bOrd));
                this.fileSetFromBrowser = true;
            }
            return null;
        }

        public BImage getIcon() {
            return browseIcon;
        }
    }

    public class CreateMipCommand
    extends Command {
        BSnmpAgent dev;

        public CreateMipCommand(BWidget bWidget, BObject bObject) {
            super(bWidget, BSnmpNetwork.TYPE.getModule().getLexicon(), "createMib");
            this.dev = (BSnmpAgent)bObject;
        }

        public CommandArtifact doInvoke() {
            BSnmpAutoMibOptions bSnmpAutoMibOptions = BSnmpAutoMibOptions.getDefault();
            try {
                BListDropDown bListDropDown;
                BSnmpLocalDeviceMenuAgent.this.fileNameTF = new BTextField("", 60);
                BSnmpLocalDeviceMenuAgent.this.fileNameTF.setText(bSnmpAutoMibOptions.getLocalMibFile());
                Browse browse = new Browse(this.getOwner());
                BButton bButton = new BButton((Command)browse);
                bButton.setButtonStyle(BButtonStyle.toolBar);
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add(null, (BValue)BSnmpLocalDeviceMenuAgent.this.fileNameTF);
                bGridPane.add(null, (BValue)bButton);
                BSnmpVersions bSnmpVersions = BSnmpVersions.v1;
                BFrozenEnumFE bFrozenEnumFE = new BFrozenEnumFE();
                bFrozenEnumFE.loadValue((BObject)bSnmpVersions);
                BGridPane bGridPane2 = new BGridPane(1);
                bGridPane2.add(null, (BValue)bFrozenEnumFE);
                BGridPane bGridPane3 = new BGridPane(2);
                bGridPane3.add(null, (BValue)new BLabel(lex.getText("createMib.mibFile")));
                bGridPane3.add(null, (BValue)bGridPane);
                bGridPane3.add(null, (BValue)new BLabel(lex.getText("createMib.snmpVersion")));
                bGridPane3.add(null, (BValue)bGridPane2);
                int n = 0;
                BSnmpVersions bSnmpVersions2 = BSnmpVersions.v1;
                String string = "";
                boolean bl = false;
                do {
                    int n2;
                    if ((n2 = BDialog.open((BWidget)this.getOwner(), (String)lex.getText("createMib.title"), (Object)bGridPane3, (int)3)) == 2) {
                        return null;
                    }
                    string = BSnmpLocalDeviceMenuAgent.this.fileNameTF.getText();
                    bListDropDown = (BListDropDown)bFrozenEnumFE.getContent();
                    int n3 = bSnmpVersions2.getRange().getOrdinals()[bListDropDown.getSelectedIndex()];
                    bSnmpVersions2 = BSnmpVersions.make(n3);
                    if (!BSnmpLocalDeviceMenuAgent.this.verifyFileExists(string)) {
                        if (n > 0) {
                            BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("createMib.error"));
                            return null;
                        }
                        BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("createMib.dirError"));
                        ++n;
                        continue;
                    }
                    bl = true;
                } while (!bl);
                bSnmpAutoMibOptions.setLocalMibFile(string);
                bSnmpAutoMibOptions.save();
                BCreateMibParameters bCreateMibParameters = new BCreateMibParameters();
                bCreateMibParameters.setFileName(string.substring(string.lastIndexOf("\\") + 1));
                bCreateMibParameters.setVersion(bSnmpVersions2);
                bListDropDown = this.dev.createMib(bCreateMibParameters);
                String string2 = bListDropDown.getString();
                BTextEditor bTextEditor = new BTextEditor();
                bTextEditor.setEditable(true);
                bTextEditor.setText(string2);
                BBorderPane bBorderPane = new BBorderPane((BWidget)bTextEditor, BBorder.solid, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
                bBorderPane.setFill(Theme.widget().getWindowBackground());
                bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
                BScrollPane bScrollPane = new BScrollPane((BWidget)bBorderPane);
                int n4 = BDialog.open((BWidget)this.getOwner(), (String)string, (Object)bScrollPane, (int)3);
                if (n4 == 2) {
                    return null;
                }
                string2 = bTextEditor.getText();
                this.saveToFile(string, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        private void saveToFile(String string, String string2) {
            try {
                BOrd bOrd = SnmpUtil.absolutePathToOrd(string);
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                PrintWriter printWriter = new PrintWriter(bIFile.getOutputStream());
                printWriter.println(string2);
                printWriter.close();
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
                throwable.printStackTrace();
            }
        }
    }
}

