/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.snmp.export.BISnmpExportFolder;
import com.tridium.snmp.export.BSnmpBooleanExport;
import com.tridium.snmp.export.BSnmpEnumExport;
import com.tridium.snmp.export.BSnmpExportFolder;
import com.tridium.snmp.export.BSnmpExportObject;
import com.tridium.snmp.export.BSnmpNumericExport;
import com.tridium.snmp.export.BSnmpStringExport;
import com.tridium.snmp.util.SnmpUtil;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;

public class BSnmpExportManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpExportManager == null ? (class$com$tridium$snmp$ui$BSnmpExportManager = BSnmpExportManager.class$("com.tridium.snmp.ui.BSnmpExportManager")) : class$com$tridium$snmp$ui$BSnmpExportManager));
    public static final Context expMgrValueContext = new BasicContext(){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "Snmp:expMgrValueContext";
        }
    };
    BISnmpExportFolder exports;
    static Lexicon lex = new UiLexicon(class$com$tridium$snmp$ui$BSnmpExportManager == null ? (class$com$tridium$snmp$ui$BSnmpExportManager = BSnmpExportManager.class$("com.tridium.snmp.ui.BSnmpExportManager")) : class$com$tridium$snmp$ui$BSnmpExportManager);
    static String lexLocalObjects = lex.getText("exportManager.local");
    static String lexExportedObjects = lex.getText("exportManager.exportedObjects");
    static String lexValue = lex.getText("exportManager.value");
    static String lexTargetName = lex.getText("exportManager.targetName");
    static String lexObjectType = lex.getText("exportManager.objectType");
    static String lexObjectIdentifier = lex.getText("exportManager.objectIdentifier");
    static String lexExportOrd = lex.getText("exportManager.exportOrd");
    static String lexExportStatus = lex.getText("exportManager.exportStatus");
    static String lexFaultCause = lex.getText("exportManager.faultCause");
    static String lexDescription = lex.getText("exportManager.description");
    static String lexSlotPath = UiLexicon.bajaui.getText("slotPath");
    static String lexHandle = UiLexicon.bajaui.getText("handle");
    static String lexType = UiLexicon.bajaui.getText("type");
    static String lexInvalidOrd = lex.getText("exportManager.invalidOrd");
    static final MgrTypeInfo SNMP_BOOLEAN_POINT = MgrTypeInfo.make((BComponent)new BSnmpBooleanExport());
    static final MgrTypeInfo SNMP_BOOLEAN_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpBooleanExport());
    static final MgrTypeInfo SNMP_NUMERIC_POINT = MgrTypeInfo.make((BComponent)new BSnmpNumericExport());
    static final MgrTypeInfo SNMP_NUMERIC_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpNumericExport());
    static final MgrTypeInfo SNMP_ENUM_POINT = MgrTypeInfo.make((BComponent)new BSnmpEnumExport());
    static final MgrTypeInfo SNMP_ENUM_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpEnumExport());
    static final MgrTypeInfo SNMP_STRING_POINT = MgrTypeInfo.make((BComponent)new BSnmpStringExport());
    static final MgrTypeInfo SNMP_STRING_WRITABLE = MgrTypeInfo.make((BComponent)new BSnmpStringExport());
    static MgrTypeInfo[] NEW_TYPES = new MgrTypeInfo[]{SNMP_NUMERIC_POINT, SNMP_BOOLEAN_POINT, SNMP_ENUM_POINT, SNMP_STRING_POINT};
    MgrColumn mcolType = new MgrColumn.Type(3);
    MgrColumn mcolName = new MgrColumn.Name(1);
    MgrColumn mcolTgtOut = new TargetOutCol();
    MgrColumn mcolTgtObj = new TargetObjCol();
    MgrColumn mcolObjId = new ObjectIdCol();
    MgrColumn mcolExportOrd = new ExportOrdCol();
    MgrColumn mcolExportStatus = new StatusCol();
    MgrColumn mcolFaultCause = new FaultCauseCol();
    MgrColumn mcolDeviceFacets = new MgrColumn.PropPath(new Property[]{BSnmpExportObject.deviceFacets}, 3);
    MgrColumn[] mcols = new MgrColumn[]{this.mcolType, this.mcolName, this.mcolTgtOut, this.mcolTgtObj, this.mcolObjId, this.mcolExportOrd, this.mcolExportStatus, this.mcolFaultCause, this.mcolDeviceFacets};
    MgrColumn dcolPath = new LearnColumn(lexSlotPath, "toPathString");
    MgrColumn dcolHandle = new LearnColumn(lexHandle, "handle", 2);
    MgrColumn dcolType = new LearnColumn(lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    static final Context folderCx = new BasicContext(){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "Snmp:folderCx";
        }
    };
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpExportManager;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;
    static /* synthetic */ Class class$com$tridium$snmp$export$BSnmpExportFolder;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrTypeInfo;
    static /* synthetic */ Class class$com$tridium$snmp$export$BSnmpExportObject;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        this.exports = (BISnmpExportFolder)bObject;
        this.registerFolder((BComponent)bObject);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
    }

    void loadDescendants() {
        BComponent bComponent = this.getCurrentValue().asComponent();
        BSnmpExportFolder[] bSnmpExportFolderArray = this.getFolders(bComponent);
        for (int i = 0; i < bSnmpExportFolderArray.length; ++i) {
            this.registerFolder((BComponent)bSnmpExportFolderArray[i]);
        }
    }

    private void registerFolder(BComponent bComponent) {
        BComponent[] bComponentArray;
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BSnmpExportManager.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            BControlPoint bControlPoint;
            bComponentArray = slotCursor.property();
            if (!bComponentArray.getType().is(BSnmpExportObject.TYPE) || (bControlPoint = ((BSnmpExportObject)slotCursor.get()).getObject()) == null) continue;
            array.add((Object)bControlPoint);
        }
        bComponentArray = (BComponent[])array.trim();
        this.registerForComponentEvents(bComponentArray, Integer.MAX_VALUE);
    }

    private BSnmpExportFolder[] getFolders(BComponent bComponent) {
        Array array = new Array(class$com$tridium$snmp$export$BSnmpExportFolder == null ? (class$com$tridium$snmp$export$BSnmpExportFolder = BSnmpExportManager.class$("com.tridium.snmp.export.BSnmpExportFolder")) : class$com$tridium$snmp$export$BSnmpExportFolder);
        this.scanForFolders(bComponent, array);
        return (BSnmpExportFolder[])array.trim();
    }

    private void scanForFolders(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (!property.getType().is(BSnmpExportFolder.TYPE)) continue;
            BComponent bComponent2 = (BComponent)slotCursor.get();
            this.registerForComponentEvents(bComponent2, 0);
            array.add((Object)bComponent2);
            this.scanForFolders(bComponent2, array);
        }
    }

    protected MgrModel makeModel() {
        return new ExportModel(this);
    }

    protected MgrLearn makeLearn() {
        return new ExportLearn(this);
    }

    protected MgrController makeController() {
        return new ExportController(this);
    }

    protected MgrState makeState() {
        return new ExportState();
    }

    void loadNodes(ExportNode[] exportNodeArray) {
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BSnmpExportManager.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        for (int i = 0; i < exportNodeArray.length; ++i) {
            ExportNode exportNode = exportNodeArray[i];
            if (exportNode.value != null) continue;
            String string = exportNode.get(this.dcolHandle).toString();
            BComponent bComponent = (BComponent)BOrd.make((String)("station:|h:" + string)).get((BObject)exportNode.session);
            exportNode.value = bComponent;
            exportNode.name = bComponent.getName();
            exportNode.path = bComponent.getSlotPath().getBody();
            array.add((Object)bComponent);
        }
        BComponent[] bComponentArray = (BComponent[])array.trim();
        BComponent.lease((BComponent[])bComponentArray, (int)0);
    }

    BISnmpExportFolder getIExportFolder() {
        return this.exports;
    }

    static void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ExportNode {
        public BFoxSession session;
        public BImage icon;
        public BObject[] cells;
        ExportNode parent;
        String name;
        String path;
        BValue value;

        public ExportNode(BFoxSession bFoxSession) {
            this.session = bFoxSession;
        }

        public String toString() {
            return "ExportNode:n=" + this.name + ", p=" + this.path + ", v=" + this.value;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn mgrColumn) {
            return ((LearnColumn)mgrColumn).get(this);
        }

        public boolean hasChildren() {
            return false;
        }

        public ExportNode[] getChildren() {
            return new ExportNode[0];
        }

        public BObject[] getCells() {
            return this.cells;
        }

        public void update(BITable bITable, int n) {
            ColumnList columnList = bITable.getColumns();
            this.cells = new BObject[columnList.size() - 1];
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i] = bITable.get(n, columnList.get(i));
            }
            this.icon = BImage.make((String)bITable.get(n, columnList.get(columnList.size() - 1)).toString());
        }

        BValue loadNode() {
            BSnmpExportManager.this.loadNodes(new ExportNode[]{this});
            return this.value;
        }

        boolean isWritable() {
            return ((BControlPoint)this.value).isWritablePoint();
        }

        BFacets getFacets() {
            return ((BControlPoint)this.value).getFacets();
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class LearnColumn
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;

        public LearnColumn(String string, String string2) {
            this(string, string2, 0);
        }

        public LearnColumn(String string, String string2, int n) {
            super(string, n);
            this.projection = string2;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] mgrColumnArray = this.getManager().getLearn().getColumns();
                for (int i = 0; i < mgrColumnArray.length; ++i) {
                    if (mgrColumnArray[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not found");
                }
            }
            return this.colIndex;
        }

        public Object get(Object object) {
            return ((ExportNode)object).getCells()[this.getColumnIndex()];
        }
    }

    public static class ExportOrdCol
    extends MgrColumn {
        public ExportOrdCol() {
            super(lexExportOrd, 3);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)object).getObjectOrd();
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) throws Exception {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)bComponent).getObjectOrd();
            }
            return BOrd.NULL;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) throws Exception {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BSnmpExportObject) {
                ((BSnmpExportObject)bComponent).setObjectOrd((BOrd)bValue);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length != 1) {
                return null;
            }
            BOrd bOrd = (BOrd)mgrEditRowArray[0].getCell(n);
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            if (bWbFieldEditor == null) {
                bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bOrd);
            }
            BFacets bFacets = BFacets.make((String)"targetType", (String)"baja:Component");
            bWbFieldEditor.loadValue((BObject)bOrd, (Context)bFacets);
            if (mgrEditRowArray[0].getTarget() instanceof BSnmpExportFolder) {
                bWbFieldEditor.setReadonly(true);
            }
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BOrd bOrd = (BOrd)bWbFieldEditor.saveValue();
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                mgrEditRowArray[i].setCell(n, (BValue)bOrd);
            }
        }
    }

    public static class TargetOutCol
    extends MgrColumn {
        public TargetOutCol() {
            super(lexValue);
        }

        public TargetOutCol(String string) {
            super(string);
        }

        public Object get(Object object) {
            try {
                if (object instanceof BSnmpExportObject) {
                    return ((BSnmpExportObject)object).getObjectOrd().get((BObject)object).toString(null);
                }
                return "";
            }
            catch (Exception exception) {
                return lexInvalidOrd;
            }
        }
    }

    static class FaultCauseCol
    extends MgrColumn {
        public FaultCauseCol() {
            super(lexFaultCause, 4);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)object).getFaultCause();
            }
            return "";
        }
    }

    static class ObjectIdCol
    extends MgrColumn {
        public ObjectIdCol() {
            super(lexObjectIdentifier, 5);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)object).getObjectIdentifier();
            }
            if (object instanceof BISnmpExportFolder) {
                return ((BISnmpExportFolder)object).getObjectIdentifier();
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) throws Exception {
            return BString.make((String)((String)this.get(mgrEditRow.getTarget())));
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) throws Exception {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BSnmpExportObject) {
                ((BSnmpExportObject)bComponent).setObjectIdentifier(((BString)bValue).toString());
            } else if (bComponent instanceof BISnmpExportFolder) {
                ((BISnmpExportFolder)bComponent).setObjectIdentifier(((BString)bValue).toString());
            }
        }
    }

    static class StatusCol
    extends MgrColumn {
        public StatusCol() {
            super(lexExportStatus, 2);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpExportObject) {
                return ((BSnmpExportObject)object).getStatus().flagsToString(null);
            }
            return "";
        }
    }

    public static class TargetObjCol
    extends MgrColumn {
        public TargetObjCol() {
            super(lexTargetName, 5);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpExportObject) {
                return this.getSlotPath((BSnmpExportObject)object);
            }
            return "";
        }

        private String getSlotPath(BSnmpExportObject bSnmpExportObject) {
            BOrd bOrd = bSnmpExportObject.getObjectOrd();
            if (bOrd == null || bOrd.isNull()) {
                return "";
            }
            BComponentSpace bComponentSpace = ((BSnmpExportManager)this.getManager()).getIExportFolder().getComponentSpace();
            try {
                return bOrd.resolve((BObject)bComponentSpace).get().asComponent().getSlotPath().getBody();
            }
            catch (Exception exception) {
                return "";
            }
        }

        public BValue load(MgrEditRow mgrEditRow) throws Exception {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BSnmpExportObject) {
                return BString.make((String)this.getSlotPath((BSnmpExportObject)bComponent));
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) throws Exception {
        }
    }

    class ExportController
    extends FolderController {
        boolean added;

        public ExportController(BSnmpExportManager bSnmpExportManager2) {
            super((BFolderManager)bSnmpExportManager2);
            this.cancel.setFlags(0);
        }

        public void updateCommands() {
            super.updateCommands();
            int[] nArray = this.getSelectedRows();
            this.edit.setEnabled(nArray.length > 0);
            ExportLearn exportLearn = (ExportLearn)this.getManager().getLearn();
            boolean bl = false;
            BLearnTable bLearnTable = this.getLearnTable();
            if (bLearnTable != null) {
                Object[] objectArray = bLearnTable.getSelectedObjects();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!exportLearn.canExport(objectArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            this.add.setEnabled(bl);
        }

        public void doAllDescendants(boolean bl) {
            super.doAllDescendants(bl);
            if (bl) {
                BSnmpExportManager.this.loadDescendants();
            }
        }

        public CommandArtifact doEdit(Context context) throws Exception {
            BComponent[] bComponentArray = this.getSelectedComponents();
            if (bComponentArray.length == 0) {
                return null;
            }
            MgrEdit mgrEdit = this.makeEdit(this.edit.getLabel());
            for (int i = 0; i < bComponentArray.length; ++i) {
                mgrEdit.addRow(bComponentArray[i]);
            }
            mgrEdit.setSelectAll(true);
            return mgrEdit.invoke(context);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            ExportLearn exportLearn = (ExportLearn)this.getManager().getLearn();
            BFoxSession bFoxSession = exportLearn.getTargetSession();
            if (bFoxSession == null) {
                return null;
            }
            exportLearn.bqlDiscover(bFoxSession, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
            try {
                ExportNode[] exportNodeArray = new ExportNode[objectArray.length];
                System.arraycopy(objectArray, 0, exportNodeArray, 0, objectArray.length);
                BSnmpExportManager.this.loadNodes(exportNodeArray);
                this.added = false;
                MgrEdit mgrEdit = new MgrEdit(this.getManager(), this.add.getLabel()){

                    public boolean prompt() throws Exception {
                        BMgrEditDialog bMgrEditDialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
                        bMgrEditDialog.setScreenSizeToPreferredSize();
                        bMgrEditDialog.setBoundsCenteredOnOwner();
                        bMgrEditDialog.open();
                        ExportController.this.added = bMgrEditDialog.getResult() == 1;
                        return ExportController.this.added;
                    }
                };
                for (int i = 0; i < objectArray.length; ++i) {
                    ExportNode exportNode = (ExportNode)objectArray[i];
                    MgrTypeInfo[] mgrTypeInfoArray = this.getManager().getLearn().toTypes((Object)exportNode);
                    if (mgrTypeInfoArray == null || mgrTypeInfoArray.length == 0) continue;
                    MgrEditRow mgrEditRow = mgrEdit.addRow((Object)exportNode, mgrTypeInfoArray);
                    ((ExportLearn)this.getManager().getLearn()).toRow(exportNode, mgrEditRow, mgrEdit);
                }
                CommandArtifact commandArtifact = mgrEdit.invoke(context);
                return commandArtifact;
            }
            catch (ActionInvokeException actionInvokeException) {
                actionInvokeException.printStackTrace();
                Throwable throwable = actionInvokeException.getCause();
                if (throwable != null) {
                    System.out.println(" AIE caused by " + throwable);
                    throwable.printStackTrace();
                }
                throw actionInvokeException;
            }
        }
    }

    class ExportState
    extends FolderState {
        ExportNode[] lastLearn;

        ExportState() {
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BSnmpExportManager bSnmpExportManager = (BSnmpExportManager)bAbstractManager;
            ExportLearn exportLearn = (ExportLearn)bSnmpExportManager.getLearn();
            this.lastLearn = exportLearn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BSnmpExportManager bSnmpExportManager = (BSnmpExportManager)bAbstractManager;
            ExportLearn exportLearn = (ExportLearn)bSnmpExportManager.getLearn();
            if (this.lastLearn != null) {
                exportLearn.updateTable(this.lastLearn);
            }
        }
    }

    class ExportLearn
    extends MgrLearn {
        BOrd bqlQuery;
        BComponent target;
        BFoxSession targetSession;
        ExportNode[] lastLearn;

        public ExportLearn(BSnmpExportManager bSnmpExportManager2) {
            super((BAbstractManager)bSnmpExportManager2);
        }

        public BComponent getTarget() {
            return this.target;
        }

        public BFoxSession getTargetSession() {
            return this.targetSession;
        }

        public String makeTableTitle() {
            return lexLocalObjects;
        }

        public void load(BComponent bComponent) {
            super.load(bComponent);
            this.target = bComponent;
            BISession bISession = bComponent.getSession();
            if (bISession instanceof BFoxSession) {
                this.targetSession = (BFoxSession)bISession;
            }
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpExportManager.this.dcols;
        }

        public BImage getIcon(Object object) {
            return ((ExportNode)object).getIcon();
        }

        public boolean isGroup(Object object) {
            return this.hasChildren(object);
        }

        public boolean hasChildren(Object object) {
            return ((ExportNode)object).hasChildren();
        }

        public Object[] getChildren(Object object) {
            return ((ExportNode)object).getChildren();
        }

        public MgrTypeInfo[] toTypes(Object object) throws Exception {
            Array array = new Array(class$javax$baja$workbench$mgr$MgrTypeInfo == null ? (class$javax$baja$workbench$mgr$MgrTypeInfo = BSnmpExportManager.class$("javax.baja.workbench.mgr.MgrTypeInfo")) : class$javax$baja$workbench$mgr$MgrTypeInfo);
            String string = BSnmpExportManager.this.dcolType.get(object).toString();
            Type type = Sys.getRegistry().getType(string).getTypeSpec().getResolvedType();
            if (type == BNumericPoint.TYPE) {
                array.add((Object)SNMP_NUMERIC_POINT);
            } else if (type == BNumericWritable.TYPE) {
                array.add((Object)SNMP_NUMERIC_WRITABLE);
            } else if (type == BBooleanPoint.TYPE) {
                array.add((Object)SNMP_BOOLEAN_POINT);
            } else if (type == BBooleanWritable.TYPE) {
                array.add((Object)SNMP_BOOLEAN_WRITABLE);
            } else if (type == BEnumPoint.TYPE) {
                array.add((Object)SNMP_ENUM_POINT);
            } else if (type == BEnumWritable.TYPE) {
                array.add((Object)SNMP_ENUM_WRITABLE);
            } else if (type == BStringPoint.TYPE) {
                array.add((Object)SNMP_STRING_POINT);
            } else if (type == BStringWritable.TYPE) {
                array.add((Object)SNMP_STRING_WRITABLE);
            }
            return (MgrTypeInfo[])array.trim();
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            this.toRow(object, mgrEditRow, mgrEditRow.getEdit());
        }

        public void toRow(Object object, MgrEditRow mgrEditRow, MgrEdit mgrEdit) throws Exception {
            ExportNode exportNode = (ExportNode)object;
            exportNode.loadNode();
            mgrEditRow.setCell(BSnmpExportManager.this.mcolName, (BValue)BString.make((String)exportNode.name));
            mgrEditRow.setCell(BSnmpExportManager.this.mcolExportOrd, (BValue)BOrd.make((String)("h:" + exportNode.get(BSnmpExportManager.this.dcolHandle).toString())));
            mgrEditRow.setCell(BSnmpExportManager.this.mcolTgtObj, (BValue)BString.make((String)SlotPath.unescape((String)exportNode.getPath().substring(1))));
            BISnmpExportFolder bISnmpExportFolder = ((BSnmpExportManager)this.getManager()).getIExportFolder();
            boolean bl = exportNode.isWritable();
            String string = bISnmpExportFolder.getObjectIdentifier() + (bl ? ".1.1.3." : ".2.1.3.") + this.getFreeNdx(bISnmpExportFolder, mgrEdit, bl);
            mgrEditRow.setCell(BSnmpExportManager.this.mcolObjId, (BValue)BString.make((String)string));
            BFacets bFacets = exportNode.getFacets();
            mgrEditRow.setCell(BSnmpExportManager.this.mcolDeviceFacets, (BValue)bFacets);
        }

        private int getFreeNdx(BISnmpExportFolder bISnmpExportFolder, MgrEdit mgrEdit, boolean bl) {
            int n;
            BSnmpExportObject[] bSnmpExportObjectArray = (BSnmpExportObject[])bISnmpExportFolder.asComponent().getChildren(class$com$tridium$snmp$export$BSnmpExportObject == null ? (class$com$tridium$snmp$export$BSnmpExportObject = BSnmpExportManager.class$("com.tridium.snmp.export.BSnmpExportObject")) : class$com$tridium$snmp$export$BSnmpExportObject);
            int[] nArray = new int[bSnmpExportObjectArray.length + mgrEdit.getRowCount()];
            int n2 = 0;
            for (n = 0; n < bSnmpExportObjectArray.length; ++n) {
                long[] lArray = SnmpUtil.getLongArray(bSnmpExportObjectArray[n].getObjectIdentifier());
                if (lArray.length < 4 || this.isWritable(lArray) != bl) continue;
                int n3 = this.getNdx(lArray);
                nArray[n2++] = n3;
            }
            n = mgrEdit.getRow(0).getColumnIndex(BSnmpExportManager.this.mcolObjId);
            for (int i = 0; i < mgrEdit.getRowCount() - 1; ++i) {
                String string = ((String)mgrEdit.getValueAt(i, n)).toString();
                long[] lArray = SnmpUtil.getLongArray(string);
                if (lArray.length < 4 || this.isWritable(lArray) != bl) continue;
                int n4 = this.getNdx(lArray);
                nArray[n2++] = n4;
            }
            return SnmpUtil.findFreeIndex(nArray, n2);
        }

        private boolean isWritable(long[] lArray) {
            return lArray[lArray.length - 4] == 1L;
        }

        private int getNdx(long[] lArray) {
            return (int)lArray[lArray.length - 1];
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            return !this.canExport(object);
        }

        private boolean canExport(Object object) {
            String string = BSnmpExportManager.this.dcolType.get(object).toString();
            TypeInfo typeInfo = Sys.getRegistry().getType(string);
            return typeInfo.is(BControlPoint.TYPE);
        }

        public void bqlDiscover(BFoxSession bFoxSession, BTypeSpec bTypeSpec) throws Exception {
            BStation bStation;
            BBqlQueryBuilder bBqlQueryBuilder;
            BOrd bOrd;
            String string;
            if (this.bqlQuery == null) {
                string = this.getBqlProjection();
                this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + string + " from " + bTypeSpec));
            }
            if ((bOrd = (bBqlQueryBuilder = new BBqlQueryBuilder((BObject)(bStation = (BStation)(string = (BComponentSpace)bFoxSession.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager())) == null) {
                return;
            }
            if (!bOrd.relativizeToSession().toString().startsWith("station")) {
                return;
            }
            this.bqlQuery = bOrd;
            BITable bITable = (BITable)bOrd.get((BObject)bStation);
            this.updateTable(bFoxSession, bITable);
        }

        public String getBqlProjection() {
            StringBuffer stringBuffer = new StringBuffer();
            MgrColumn[] mgrColumnArray = this.getColumns();
            for (int i = 0; i < mgrColumnArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                LearnColumn learnColumn = (LearnColumn)mgrColumnArray[i];
                stringBuffer.append(learnColumn.projection);
            }
            stringBuffer.append(",icon");
            return stringBuffer.toString();
        }

        public void updateTable(BFoxSession bFoxSession, BITable bITable) {
            Object[] objectArray = new ExportNode[bITable.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.makeNode(bFoxSession);
                ((ExportNode)objectArray[i]).update(bITable, i);
            }
            this.lastLearn = objectArray;
            this.updateRoots(objectArray);
        }

        void updateTable(ExportNode[] exportNodeArray) {
            this.lastLearn = exportNodeArray;
            this.updateRoots(exportNodeArray);
        }

        protected ExportNode makeNode(BFoxSession bFoxSession) {
            return new ExportNode(bFoxSession);
        }
    }

    class ExportModel
    extends FolderModel {
        public ExportModel(BSnmpExportManager bSnmpExportManager2) {
            super((BFolderManager)bSnmpExportManager2);
        }

        public String makeTableTitle() {
            return lexExportedObjects;
        }

        public Type getFolderType() {
            return BSnmpExportFolder.TYPE;
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpExportManager.this.mcols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BSnmpExportObject.TYPE, BISnmpExportFolder.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return NEW_TYPES;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BComponent bComponent = mgrTypeInfo.newInstance();
            return bComponent;
        }
    }
}

