/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.util.SnmpUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BMibListDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BMibListDialog == null ? (class$com$tridium$snmp$ui$BMibListDialog = BMibListDialog.class$("com.tridium.snmp.ui.BMibListDialog")) : class$com$tridium$snmp$ui$BMibListDialog));
    static Lexicon lex = Lexicon.make((Class)(class$com$tridium$snmp$ui$BMibListDialog == null ? (class$com$tridium$snmp$ui$BMibListDialog = BMibListDialog.class$("com.tridium.snmp.ui.BMibListDialog")) : class$com$tridium$snmp$ui$BMibListDialog));
    BList mibs;
    static /* synthetic */ Class class$com$tridium$snmp$ui$BMibListDialog;

    public Type getType() {
        return TYPE;
    }

    public BMibListDialog() {
    }

    public BMibListDialog(String[] stringArray) {
        this.mibs = new BList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mibs.addItem((Object)stringArray[i]);
        }
        AddMib addMib = new AddMib((BWidget)this);
        RemoveMib removeMib = new RemoveMib((BWidget)this);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton((Command)addMib));
        bGridPane.add(null, (BValue)new BButton((Command)removeMib));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.mibs));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane));
        this.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane));
    }

    public void computePreferredSize() {
        int n = Math.max((int)this.getPreferredWidth(), 300);
        int n2 = Math.max((int)this.getPreferredHeight(), 200);
        this.setPreferredSize(n, n2);
    }

    public String[] getMibPaths() {
        int n = this.mibs.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.mibs.getItem(i);
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RemoveMib
    extends Command {
        RemoveMib(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui.getText("action.remove"), BImage.make((String)"module://icons/x16/delete.png"), null, null);
        }

        public CommandArtifact doInvoke() {
            BMibListDialog.this.mibs.removeSelectedItems();
            return null;
        }
    }

    class AddMib
    extends Command {
        AddMib(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui.getText("action.add"), BImage.make((String)"module://icons/x16/add.png"), null, null);
        }

        public CommandArtifact doInvoke() {
            BDirectoryChooser bDirectoryChooser = BDirectoryChooser.make((BWidget)this.getOwner());
            bDirectoryChooser.setTitle(lex.getText("mibPathDialog.addDirectory"));
            BOrd bOrd = bDirectoryChooser.show();
            if (bOrd == null) {
                return null;
            }
            try {
                BMibListDialog.this.mibs.addItem((Object)SnmpUtil.ordToAbsolutePath(bOrd));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

