/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.table;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.OidUtil;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.table.BSnmpSequence;
import com.tridium.snmp.table.BSnmpSequenceElement;
import com.tridium.snmp.table.BSnmpTableElementTypeEnum;
import com.tridium.snmp.table.BSnmpTableRow;
import com.tridium.snmp.table.BSnmpTableWalkMibJob;
import com.tridium.snmp.util.SnmpUtil;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.IntegerType;

public class BSnmpTable
extends BComponent {
    public static final Property objectIdentifier = BSnmpTable.newProperty((int)0, (String)"", null);
    public static final Property sequence = BSnmpTable.newProperty((int)0, (BValue)new BSnmpSequence(), null);
    public static final Property enablePoll = BSnmpTable.newProperty((int)0, (boolean)true, null);
    public static final Action walkMib = BSnmpTable.newAction((int)0, null);
    public static final Action update = BSnmpTable.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$table$BSnmpTable == null ? (class$com$tridium$snmp$table$BSnmpTable = BSnmpTable.class$("com.tridium.snmp.table.BSnmpTable")) : class$com$tridium$snmp$table$BSnmpTable));
    BSnmpDevice device = null;
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/widgets/table.png");
    public static BasicContext noWrite = new BasicContext();
    static /* synthetic */ Class class$com$tridium$snmp$table$BSnmpTable;
    static /* synthetic */ Class class$net$percederberg$mibble$type$SequenceOfType;
    static /* synthetic */ Class class$net$percederberg$mibble$type$SequenceType;
    static /* synthetic */ Class class$com$tridium$snmp$table$BSnmpTableRow;
    static /* synthetic */ Class class$javax$baja$status$BStatusValue;

    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    public void setObjectIdentifier(String string) {
        this.setString(objectIdentifier, string, null);
    }

    public BSnmpSequence getSequence() {
        return (BSnmpSequence)this.get(sequence);
    }

    public void setSequence(BSnmpSequence bSnmpSequence) {
        this.set(sequence, (BValue)bSnmpSequence, null);
    }

    public boolean getEnablePoll() {
        return this.getBoolean(enablePoll);
    }

    public void setEnablePoll(boolean bl) {
        this.setBoolean(enablePoll, bl, null);
    }

    public BOrd walkMib() {
        return (BOrd)this.invoke(walkMib, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSnmpTable() {
    }

    public BSnmpTable(String string, Mib mib) {
        this.setObjectIdentifier(string);
        MibValueSymbol mibValueSymbol = mib.getSymbolByOid(string);
        if (!this.isSyntaxType(mibValueSymbol, class$net$percederberg$mibble$type$SequenceOfType == null ? (class$net$percederberg$mibble$type$SequenceOfType = BSnmpTable.class$("net.percederberg.mibble.type.SequenceOfType")) : class$net$percederberg$mibble$type$SequenceOfType)) {
            throw new BajaRuntimeException("Cannot create SnmpTable: not a sequence table");
        }
        MibValueSymbol mibValueSymbol2 = mibValueSymbol.getChildren()[0];
        if (!this.isSyntaxType(mibValueSymbol2, class$net$percederberg$mibble$type$SequenceType == null ? (class$net$percederberg$mibble$type$SequenceType = BSnmpTable.class$("net.percederberg.mibble.type.SequenceType")) : class$net$percederberg$mibble$type$SequenceType)) {
            throw new BajaRuntimeException("Cannot create SnmpTable: not a sequenceType");
        }
        MibValueSymbol[] mibValueSymbolArray = mibValueSymbol2.getChildren();
        BSnmpSequence bSnmpSequence = this.getSequence();
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            bSnmpSequence.add(SlotPath.escape((String)mibValueSymbolArray[i].getName()), (BValue)this.createSequenceElement(mibValueSymbolArray[i]));
        }
    }

    private boolean isSyntaxType(MibValueSymbol mibValueSymbol, Class clazz) {
        MibType mibType = mibValueSymbol.getType();
        if (!(mibType instanceof SnmpObjectType)) {
            return false;
        }
        MibType mibType2 = ((SnmpObjectType)mibType).getSyntax();
        return clazz.isInstance(mibType2);
    }

    public void started() throws Exception {
        super.started();
        this.snmpDev().registerTable(this);
    }

    public void stopped() throws Exception {
        this.snmpDev().unregisterTable(this);
        super.stopped();
    }

    private BSnmpSequenceElement createSequenceElement(MibValueSymbol mibValueSymbol) {
        SnmpObjectType snmpObjectType = (SnmpObjectType)mibValueSymbol.getType();
        BSnmpSequenceElement bSnmpSequenceElement = new BSnmpSequenceElement();
        bSnmpSequenceElement.setObjectIdentifier(mibValueSymbol.getValue().toString());
        bSnmpSequenceElement.setElementName(mibValueSymbol.getName());
        boolean bl = OidUtil.getAccess(snmpObjectType.getAccess()).isWriteable();
        bSnmpSequenceElement.setWriteable(bl);
        BSnmpVariableTypeEnum bSnmpVariableTypeEnum = BSnmpVariableTypeEnum.getVariableTypeFromTag(snmpObjectType.getSyntax().getTag());
        bSnmpSequenceElement.setVariableType(bSnmpVariableTypeEnum);
        BEnumRange bEnumRange = null;
        MibType mibType = snmpObjectType.getSyntax();
        if (mibType instanceof IntegerType && (bEnumRange = OidUtil.getEnumRange((IntegerType)mibType)) != null) {
            bSnmpSequenceElement.setElementType(BSnmpTableElementTypeEnum.statusEnum);
            bSnmpSequenceElement.setFacets(BFacets.makeEnum((BEnumRange)bEnumRange));
        } else if (bSnmpVariableTypeEnum.isNumeric()) {
            bSnmpSequenceElement.setElementType(BSnmpTableElementTypeEnum.statusNumeric);
        } else {
            bSnmpSequenceElement.setElementType(BSnmpTableElementTypeEnum.statusString);
        }
        return bSnmpSequenceElement;
    }

    public BSnmpDevice snmpDev() {
        if (this.device == null) {
            BComplex bComplex = this.getParent();
            while (!(bComplex instanceof BSnmpDevice)) {
                bComplex = bComplex.getParent();
            }
            this.device = (BSnmpDevice)bComplex;
        }
        return this.device;
    }

    public void poll() {
        if (this.getEnablePoll()) {
            this.readTable(null);
        }
    }

    public void doUpdate() {
        Runnable runnable = new Runnable(){

            public void run() {
                BSnmpTable.this.readTable(null);
            }
        };
        this.snmpDev().snmpNet().postRequest(runnable);
    }

    void readTable(BSnmpTableWalkMibJob bSnmpTableWalkMibJob) {
        int n;
        Object object;
        SnmpVarBind[] snmpVarBindArray;
        BSnmpTableRow[] bSnmpTableRowArray;
        BSnmpDevice bSnmpDevice = this.snmpDev();
        BSnmpNetwork bSnmpNetwork = bSnmpDevice.snmpNet();
        int n2 = bSnmpDevice.getMaxVariableBindingsPerRequest();
        boolean bl = bSnmpDevice.getSnmpVersion() > 1;
        long[] lArray = SnmpUtil.getLongArray(this.getObjectIdentifier());
        int n3 = lArray.length + 1;
        BSnmpSequenceElement[] bSnmpSequenceElementArray = this.getSequence().getElements();
        if (bl) {
            bSnmpTableRowArray = new SnmpVarBind(new SnmpOID(lArray), new SnmpNull());
            snmpVarBindArray = new SnmpVarBind[]{bSnmpTableRowArray};
        } else {
            snmpVarBindArray = new SnmpVarBind[bSnmpSequenceElementArray.length];
            for (int i = 0; i < bSnmpSequenceElementArray.length; ++i) {
                object = bSnmpSequenceElementArray[i];
                long[] lArray2 = SnmpUtil.getLongArray(((BSnmpSequenceElement)((Object)object)).getObjectIdentifier());
                SnmpOID snmpOID = new SnmpOID(lArray2);
                snmpVarBindArray[i] = new SnmpVarBind(snmpOID, new SnmpNull());
                if (i != 0) continue;
                lArray = lArray2;
            }
        }
        bSnmpTableRowArray = (BSnmpTableRow[])this.getChildren(class$com$tridium$snmp$table$BSnmpTableRow == null ? (class$com$tridium$snmp$table$BSnmpTableRow = BSnmpTable.class$("com.tridium.snmp.table.BSnmpTableRow")) : class$com$tridium$snmp$table$BSnmpTableRow);
        object = new Hashtable();
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n6;
            SnmpPDU snmpPDU;
            if (bSnmpTableWalkMibJob != null) {
                if (bSnmpTableWalkMibJob.walkCanceled) {
                    return;
                }
                bSnmpTableWalkMibJob.progress(n5++);
                if (n5 >= 95) {
                    n5 = 50;
                }
            }
            n = -1;
            if (bl) {
                snmpPDU = new SnmpPDU(bSnmpDevice, 165);
                snmpPDU.setMaxRepetitions(n2);
                snmpPDU.addVariableBinding(snmpVarBindArray[0]);
            } else {
                snmpPDU = new SnmpPDU(bSnmpDevice, 161);
                for (int i = 0; i < n2 && i < snmpVarBindArray.length; ++i) {
                    if (n4 == 0) {
                        n = i;
                    }
                    snmpPDU.addVariableBinding(snmpVarBindArray[n4++]);
                    if (n4 < snmpVarBindArray.length) continue;
                    n4 = 0;
                }
            }
            SnmpPDU snmpPDU2 = bSnmpNetwork.sendAsyncRequest(snmpPDU, (int)bSnmpDevice.getResponseTimeout().getMillis(), bSnmpDevice.getRetryCount());
            if (snmpPDU2 == null) {
                bSnmpNetwork.getSnmpLog().error("poll failed in " + this.getName());
                return;
            }
            Vector vector = snmpPDU2.getVariableBindings();
            for (n6 = 0; n6 < vector.size(); ++n6) {
                SnmpVarBind snmpVarBind = (SnmpVarBind)vector.get(n6);
                SnmpVar snmpVar = snmpVarBind.getVariable();
                long[] lArray3 = snmpVarBind.getObjectID().toLongArray();
                if (snmpVar instanceof SnmpExceptionVar) {
                    bl2 = true;
                    break;
                }
                if ((bl || n6 == n) && !this.isOidForMyTable(lArray, lArray3)) {
                    bl2 = true;
                    break;
                }
                int n7 = (int)lArray3[n3] - 1;
                String string = SnmpUtil.rowIdFromOid(lArray3, n3);
                snmpVarBindArray[bl ? 0 : n7] = snmpVarBind;
                BSnmpTableRow bSnmpTableRow = null;
                for (int i = 0; i < bSnmpTableRowArray.length; ++i) {
                    if (!bSnmpTableRowArray[i].getIndex().equals(string)) continue;
                    bSnmpTableRow = bSnmpTableRowArray[i];
                    break;
                }
                if (bSnmpTableRow == null) {
                    Property property = this.add(SlotPath.escape((String)("row" + string)), (BValue)this.createRow(string, bSnmpSequenceElementArray), null);
                    bSnmpTableRow = (BSnmpTableRow)this.get(property);
                    bSnmpTableRowArray = (BSnmpTableRow[])this.getChildren(class$com$tridium$snmp$table$BSnmpTableRow == null ? BSnmpTable.class$("com.tridium.snmp.table.BSnmpTableRow") : class$com$tridium$snmp$table$BSnmpTableRow);
                }
                ((Hashtable)object).put(string, bSnmpTableRow);
                BStatusValue bStatusValue = (BStatusValue)bSnmpTableRow.get(SlotPath.escape((String)bSnmpSequenceElementArray[n7].getElementName()));
                try {
                    BEnumRange bEnumRange;
                    if (bStatusValue instanceof BStatusNumeric) {
                        ((BStatusNumeric)bStatusValue).setDouble(BStatusNumeric.value, SnmpUtil.getNumeric(snmpVar), (Context)noWrite);
                    } else if (bStatusValue instanceof BStatusEnum) {
                        bEnumRange = (BEnumRange)bSnmpSequenceElementArray[n7].getFacets().getFacet("range");
                        ((BStatusEnum)bStatusValue).set(BStatusEnum.value, (BValue)SnmpUtil.getEnum(snmpVar, bEnumRange), (Context)noWrite);
                    } else if (bStatusValue instanceof BStatusBoolean) {
                        int[] nArray;
                        bEnumRange = bSnmpSequenceElementArray[n7].getFacets();
                        BEnumRange bEnumRange2 = (BEnumRange)bEnumRange.getFacet("range");
                        if (bEnumRange2 != null && (nArray = bEnumRange2.getOrdinals()).length == 2) {
                            String string2 = bEnumRange2.getTag(nArray[0]);
                            String string3 = bEnumRange2.getTag(nArray[1]);
                            bEnumRange = BFacets.make((BFacets)bEnumRange, (BFacets)BFacets.makeBoolean((String)string2, (String)string3));
                        }
                        ((BStatusBoolean)bStatusValue).setBoolean(BStatusBoolean.value, SnmpUtil.getBoolean(snmpVar, (BFacets)bEnumRange), (Context)noWrite);
                    } else if (bStatusValue instanceof BStatusString) {
                        ((BStatusString)bStatusValue).setString(BStatusString.value, SnmpUtil.getString(snmpVar), (Context)noWrite);
                    }
                    bStatusValue.setStatusNull(false);
                    continue;
                }
                catch (Throwable throwable) {
                    bStatusValue.setStatusNull(true);
                }
            }
            for (n6 = 0; n6 < snmpVarBindArray.length; ++n6) {
                snmpVarBindArray[n6].setVariable(new SnmpNull());
            }
        }
        for (n = 0; n < bSnmpTableRowArray.length; ++n) {
            if (((Hashtable)object).get(bSnmpTableRowArray[n].getIndex()) != null) continue;
            this.remove((BComplex)bSnmpTableRowArray[n]);
        }
    }

    private boolean isOidForMyTable(long[] lArray, long[] lArray2) {
        if (lArray2.length < lArray.length) {
            return false;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray2[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    public BOrd doWalkMib() {
        if (!this.snmpDev().isActive()) {
            throw new LocalizableRuntimeException("snmp", "walkMib.deviceInactive");
        }
        return new BSnmpTableWalkMibJob(this.snmpDev(), this).submit(null);
    }

    private BSnmpTableRow createRow(String string, BSnmpSequenceElement[] bSnmpSequenceElementArray) {
        BSnmpTableRow bSnmpTableRow = new BSnmpTableRow();
        bSnmpTableRow.setIndex(string);
        for (int i = 0; i < bSnmpSequenceElementArray.length; ++i) {
            int n;
            BStatusValue bStatusValue = bSnmpSequenceElementArray[i].getElementType().getInstance();
            int n2 = n = bSnmpSequenceElementArray[i].getWriteable() ? 0 : 1;
            if (bSnmpSequenceElementArray[i].getFacets().isNull()) {
                bSnmpTableRow.add(SlotPath.escape((String)bSnmpSequenceElementArray[i].getElementName()), (BValue)bStatusValue, n);
                continue;
            }
            bSnmpTableRow.add(SlotPath.escape((String)bSnmpSequenceElementArray[i].getElementName()), (BValue)bStatusValue, n, bSnmpSequenceElementArray[i].getFacets(), null);
        }
        return bSnmpTableRow;
    }

    public void updateStatus() {
        try {
            BSnmpDevice bSnmpDevice = this.snmpDev();
            boolean bl = bSnmpDevice.isDown();
            boolean bl2 = bSnmpDevice.isFault();
            boolean bl3 = bSnmpDevice.isDisabled();
            BSnmpTableRow[] bSnmpTableRowArray = (BSnmpTableRow[])this.getChildren(class$com$tridium$snmp$table$BSnmpTableRow == null ? (class$com$tridium$snmp$table$BSnmpTableRow = BSnmpTable.class$("com.tridium.snmp.table.BSnmpTableRow")) : class$com$tridium$snmp$table$BSnmpTableRow);
            for (int i = 0; i < bSnmpTableRowArray.length; ++i) {
                BStatusValue[] bStatusValueArray = (BStatusValue[])bSnmpTableRowArray[i].getChildren(class$javax$baja$status$BStatusValue == null ? BSnmpTable.class$("javax.baja.status.BStatusValue") : class$javax$baja$status$BStatusValue);
                for (int j = 0; j < bStatusValueArray.length; ++j) {
                    int n;
                    int n2 = n = bStatusValueArray[j].getStatus().getBits();
                    n2 = bl3 ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
                    n2 = bl ? (n2 |= 4) : (n2 &= 0xFFFFFFFB);
                    n2 = bl2 ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
                    if (n == n2) continue;
                    bStatusValueArray[j].set(BStatusValue.status, (BValue)BStatus.make((int)n2), (Context)noWrite);
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            throwable.printStackTrace();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

