/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.snmp.services.BSnmpRecipient;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.net.InetAddress;
import javax.baja.sys.Sys;

public class SnmpTrap
extends SnmpPDU {
    protected BSnmpNetwork snmp;
    private int port = 162;
    private InetAddress managerIp;
    private int snmpVersion;
    private int genericType;
    private int specificType;
    private String community;
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;

    public SnmpTrap(BSnmpNetwork bSnmpNetwork, int n, int n2) {
        this.genericType = n;
        this.specificType = n2;
        this.snmp = bSnmpNetwork;
        this.managerIp = bSnmpNetwork.getManagerIp();
        this.port = bSnmpNetwork.getDefaultNetworkManagerTrapsPort();
        this.snmpVersion = bSnmpNetwork.getDefaultNetworkManagerSnmpVersion();
        this.community = bSnmpNetwork.getDefaultNetworkManagerTrapsCommunity();
        this.init();
    }

    public SnmpTrap(BSnmpRecipient bSnmpRecipient, int n, int n2) {
        this.genericType = n;
        this.specificType = n2;
        this.snmp = bSnmpRecipient.snmp();
        BNetworkManagerConfiguration bNetworkManagerConfiguration = bSnmpRecipient.getNetworkManagerConfig();
        this.managerIp = bNetworkManagerConfiguration.getManagerIp();
        this.port = bNetworkManagerConfiguration.getNetworkManagerTrapsPort();
        this.snmpVersion = bNetworkManagerConfiguration.getNetworkManagerSnmpVersion();
        this.community = bNetworkManagerConfiguration.getNetworkManagerTrapsCommunity();
        this.init();
    }

    private void init() {
        block4: {
            if (this.snmpVersion == 2) {
                this.setVersion(1);
                this.setCommand(167);
            } else {
                this.setVersion(0);
                this.setCommand(164);
            }
            this.setCommunity(this.community);
            try {
                this.setEnterprise(new SnmpOID(this.genericType >= 0 && this.genericType <= 5 ? "1.3.6.1.2.1.11" : "1.3.6.1.4.1.4131.1"));
                this.setSourceIp(Sys.getLocalHost());
                this.setDestinationIp(this.managerIp);
                this.setTrapType(this.genericType);
                this.setSpecificType(this.specificType);
            }
            catch (Exception exception) {
                if (this.snmp == null) break block4;
                this.snmp.getSnmpLog().error("Unable to create SnmpTrap - ", (Throwable)exception);
            }
        }
    }

    public synchronized void send() {
        block2: {
            try {
                this.setRemotePort(this.port);
                this.setUpTime(this.snmp.getTimeTick());
                ComUtil.send(this.snmp, this);
            }
            catch (Exception exception) {
                if (this.snmp == null) break block2;
                this.snmp.getSnmpLog().error("Unable to send SnmpTrap - ", (Throwable)exception);
            }
        }
    }

    public void addStringVariable(String string, String string2) {
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpString snmpString = new SnmpString(string2);
        this.addVariableBinding(new SnmpVarBind(snmpOID, snmpString));
    }

    public void addIntegerVariable(String string, int n) {
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpInt snmpInt = new SnmpInt(n);
        this.addVariableBinding(new SnmpVarBind(snmpOID, snmpInt));
    }
}

